/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.sponge.config;

import com.google.common.reflect.TypeToken;
import com.vexsoftware.votifier.sponge.NuVotifier;
import com.vexsoftware.votifier.sponge.config.SpongeConfig;
import java.io.File;
import java.io.IOException;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;

public class ConfigLoader {
    private static SpongeConfig spongeConfig;

    public static void loadConfig(NuVotifier pl) {
        if (!pl.getConfigDir().exists() && !pl.getConfigDir().mkdirs()) {
            throw new RuntimeException("Unable to create the plugin data folder " + pl.getConfigDir());
        }
        try {
            File config = new File(pl.getConfigDir(), "config.yml");
            if (!config.exists() && !config.createNewFile()) {
                throw new IOException("Unable to create the config file at " + config);
            }
            YAMLConfigurationLoader loader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setFile(config)).build();
            ConfigurationNode configNode = loader.load(ConfigurationOptions.defaults().setShouldCopyDefaults(true));
            spongeConfig = (SpongeConfig)configNode.getValue(TypeToken.of(SpongeConfig.class), (Object)new SpongeConfig());
            loader.save(configNode);
        }
        catch (Exception e) {
            pl.getLogger().error("Could not load config.", (Throwable)e);
        }
    }

    public static SpongeConfig getSpongeConfig() {
        return spongeConfig;
    }
}

