/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.sponge;

import com.vexsoftware.votifier.platform.scheduler.ScheduledVotifierTask;
import com.vexsoftware.votifier.platform.scheduler.VotifierScheduler;
import com.vexsoftware.votifier.sponge.NuVotifier;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.Task;

class SpongeScheduler
implements VotifierScheduler {
    private final NuVotifier plugin;

    SpongeScheduler(NuVotifier plugin) {
        this.plugin = plugin;
    }

    private Task.Builder taskBuilder(Runnable runnable) {
        return Sponge.getScheduler().createTaskBuilder().execute(runnable);
    }

    @Override
    public ScheduledVotifierTask sync(Runnable runnable) {
        return new TaskWrapper(this.taskBuilder(runnable).submit((Object)this.plugin));
    }

    @Override
    public ScheduledVotifierTask onPool(Runnable runnable) {
        return new TaskWrapper(this.taskBuilder(runnable).async().submit((Object)this.plugin));
    }

    @Override
    public ScheduledVotifierTask delayedSync(Runnable runnable, int delay, TimeUnit unit) {
        return new TaskWrapper(this.taskBuilder(runnable).delay((long)delay, unit).submit((Object)this.plugin));
    }

    @Override
    public ScheduledVotifierTask delayedOnPool(Runnable runnable, int delay, TimeUnit unit) {
        return new TaskWrapper(this.taskBuilder(runnable).delay((long)delay, unit).async().submit((Object)this.plugin));
    }

    @Override
    public ScheduledVotifierTask repeatOnPool(Runnable runnable, int delay, int repeat, TimeUnit unit) {
        return new TaskWrapper(this.taskBuilder(runnable).delay((long)delay, unit).interval((long)repeat, unit).submit((Object)this.plugin));
    }

    private static class TaskWrapper
    implements ScheduledVotifierTask {
        private final Task task;

        private TaskWrapper(Task task) {
            this.task = task;
        }

        @Override
        public void cancel() {
            this.task.cancel();
        }
    }
}

