/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.sponge;

import com.google.inject.Inject;
import com.vexsoftware.votifier.VoteHandler;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.net.VotifierServerBootstrap;
import com.vexsoftware.votifier.net.VotifierSession;
import com.vexsoftware.votifier.net.protocol.v1crypto.RSAIO;
import com.vexsoftware.votifier.net.protocol.v1crypto.RSAKeygen;
import com.vexsoftware.votifier.platform.LoggingAdapter;
import com.vexsoftware.votifier.platform.VotifierPlugin;
import com.vexsoftware.votifier.platform.scheduler.VotifierScheduler;
import com.vexsoftware.votifier.sponge.SLF4JLogger;
import com.vexsoftware.votifier.sponge.SpongeScheduler;
import com.vexsoftware.votifier.sponge.cmd.NVReloadCmd;
import com.vexsoftware.votifier.sponge.cmd.TestVoteCmd;
import com.vexsoftware.votifier.sponge.config.ConfigLoader;
import com.vexsoftware.votifier.sponge.event.VotifierEvent;
import com.vexsoftware.votifier.sponge.forwarding.SpongePluginMessagingForwardingSink;
import com.vexsoftware.votifier.support.forwarding.ForwardedVoteListener;
import com.vexsoftware.votifier.support.forwarding.ForwardingVoteSink;
import com.vexsoftware.votifier.util.KeyCreator;
import java.io.File;
import java.security.Key;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.text.Text;

@Plugin(id="nuvotifier", name="NuVotifier", version="2.7.3", authors={"Ichbinjoe"}, description="Safe, smart, and secure Votifier server plugin")
public class NuVotifier
implements VoteHandler,
VotifierPlugin,
ForwardedVoteListener {
    @Inject
    public Logger logger;
    private SLF4JLogger loggerAdapter;
    @Inject
    @ConfigDir(sharedRoot=false)
    public File configDir;
    private VotifierScheduler scheduler;
    private VotifierServerBootstrap bootstrap;
    private KeyPair keyPair;
    private boolean debug;
    private Map<String, Key> tokens = new HashMap<String, Key>();
    private ForwardingVoteSink forwardingMethod;

    private boolean loadAndBind() {
        ConfigLoader.loadConfig(this);
        File rsaDirectory = new File(this.configDir, "rsa");
        try {
            if (!rsaDirectory.exists()) {
                if (!rsaDirectory.mkdir()) {
                    throw new RuntimeException("Unable to create the RSA key folder " + rsaDirectory);
                }
                this.keyPair = RSAKeygen.generate(2048);
                RSAIO.save(rsaDirectory, this.keyPair);
            } else {
                this.keyPair = RSAIO.load(rsaDirectory);
            }
        }
        catch (Exception ex) {
            this.logger.error("Error creating or reading RSA tokens", (Throwable)ex);
            return false;
        }
        this.debug = ConfigLoader.getSpongeConfig().debug;
        ConfigLoader.getSpongeConfig().tokens.forEach((s, s2) -> {
            this.tokens.put((String)s, KeyCreator.createKeyFrom(s2));
            this.logger.info("Loaded token for website: " + s);
        });
        String host = ConfigLoader.getSpongeConfig().host;
        int port = ConfigLoader.getSpongeConfig().port;
        if (!this.debug) {
            this.logger.info("QUIET mode enabled!");
        }
        if (port >= 0) {
            boolean disablev1 = ConfigLoader.getSpongeConfig().disableV1Protocol;
            if (disablev1) {
                this.logger.info("------------------------------------------------------------------------------");
                this.logger.info("Votifier protocol v1 parsing has been disabled. Most voting websites do not");
                this.logger.info("currently support the modern Votifier protocol in NuVotifier.");
                this.logger.info("------------------------------------------------------------------------------");
            }
            this.bootstrap = new VotifierServerBootstrap(host, port, this, disablev1);
            this.bootstrap.start(err -> {});
        } else {
            this.getLogger().info("------------------------------------------------------------------------------");
            this.getLogger().info("Your Votifier port is less than 0, so we assume you do NOT want to start the");
            this.getLogger().info("votifier port server! Votifier will not listen for votes over any port, and");
            this.getLogger().info("will only listen for pluginMessaging forwarded votes!");
            this.getLogger().info("------------------------------------------------------------------------------");
        }
        if (ConfigLoader.getSpongeConfig().forwarding != null) {
            String method = ConfigLoader.getSpongeConfig().forwarding.method.toLowerCase();
            if ("none".equals(method)) {
                this.getLogger().info("Method none selected for vote forwarding: Votes will not be received from a forwarder.");
            } else if ("pluginmessaging".equals(method)) {
                String channel = ConfigLoader.getSpongeConfig().forwarding.pluginMessaging.channel;
                try {
                    this.forwardingMethod = new SpongePluginMessagingForwardingSink(this, channel, this);
                    this.getLogger().info("Receiving votes over PluginMessaging channel '" + channel + "'.");
                }
                catch (RuntimeException e) {
                    this.logger.error("NuVotifier could not set up PluginMessaging for vote forwarding!", (Throwable)e);
                }
            } else {
                this.logger.error("No vote forwarding method '" + method + "' known. Defaulting to noop implementation.");
            }
        }
        return true;
    }

    private void halt() {
        if (this.bootstrap != null) {
            this.bootstrap.shutdown();
            this.bootstrap = null;
        }
        if (this.forwardingMethod != null) {
            this.forwardingMethod.halt();
            this.forwardingMethod = null;
        }
    }

    public boolean reload() {
        try {
            this.halt();
        }
        catch (Exception ex) {
            this.logger.error("On halt, an exception was thrown. This may be fine!", (Throwable)ex);
        }
        if (this.loadAndBind()) {
            this.logger.info("Reload was successful.");
            return true;
        }
        try {
            this.halt();
            this.logger.error("On reload, there was a problem with the configuration. Votifier currently does nothing!");
        }
        catch (Exception ex) {
            this.logger.error("On reload, there was a problem loading, and we could not re-halt the server. Votifier is in an unstable state!", (Throwable)ex);
        }
        return false;
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        this.scheduler = new SpongeScheduler(this);
        this.loggerAdapter = new SLF4JLogger(this.logger);
        CommandSpec nvreloadSpec = CommandSpec.builder().description((Text)Text.of((String)"Reloads NuVotifier")).permission("nuvotifier.reload").executor((CommandExecutor)new NVReloadCmd(this)).build();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)nvreloadSpec, new String[]{"nvreload"});
        CommandSpec testvoteSpec = CommandSpec.builder().arguments(GenericArguments.allOf((CommandElement)GenericArguments.string((Text)Text.of((String)"args")))).description((Text)Text.of((String)"Sends a test vote to the server's listeners")).permission("nuvotifier.testvote").executor((CommandExecutor)new TestVoteCmd(this)).build();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)testvoteSpec, new String[]{"testvote"});
        if (!this.loadAndBind()) {
            this.gracefulExit();
        }
    }

    @Listener
    public void onGameReload(GameReloadEvent event) {
        this.reload();
    }

    @Listener
    public void onServerStop(GameStoppingServerEvent event) {
        this.halt();
        this.logger.info("Votifier disabled.");
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void gracefulExit() {
        this.logger.error("Votifier did not initialize properly!");
    }

    @Override
    public LoggingAdapter getPluginLogger() {
        return this.loggerAdapter;
    }

    @Override
    public VotifierScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public Map<String, Key> getTokens() {
        return this.tokens;
    }

    @Override
    public KeyPair getProtocolV1Key() {
        return this.keyPair;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    @Override
    public void onVoteReceived(Vote vote, VotifierSession.ProtocolVersion protocolVersion, String remoteAddress) {
        if (this.debug) {
            if (protocolVersion == VotifierSession.ProtocolVersion.ONE) {
                this.logger.info("Got a protocol v1 vote record from " + remoteAddress + " -> " + vote);
            } else {
                this.logger.info("Got a protocol v2 vote record from " + remoteAddress + " -> " + vote);
            }
        }
        this.fireVoteEvent(vote);
    }

    @Override
    public void onError(Throwable throwable, boolean alreadyHandledVote, String remoteAddress) {
        if (this.debug) {
            if (alreadyHandledVote) {
                this.logger.error("Vote processed, however an exception occurred with a vote from " + remoteAddress, throwable);
            } else {
                this.logger.error("Unable to process vote from " + remoteAddress, throwable);
            }
        } else if (!alreadyHandledVote) {
            this.logger.error("Unable to process vote from " + remoteAddress);
        }
    }

    @Override
    public void onForward(Vote v) {
        if (this.debug) {
            this.logger.info("Got a forwarded vote -> " + v);
        }
        this.fireVoteEvent(v);
    }

    private void fireVoteEvent(Vote vote) {
        Sponge.getScheduler().createTaskBuilder().execute(() -> {
            VotifierEvent event = new VotifierEvent(vote, Sponge.getCauseStackManager().getCurrentCause());
            Sponge.getEventManager().post((Event)event);
        }).submit((Object)this);
    }
}

