/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.net.protocol.v1crypto;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class RSAIO {
    public static void save(File directory, KeyPair keyPair) throws Exception {
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X509EncodedKeySpec publicSpec = new X509EncodedKeySpec(publicKey.getEncoded());
        PKCS8EncodedKeySpec privateSpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        try (FileOutputStream publicOut = new FileOutputStream(directory + "/public.key");
             FileOutputStream privateOut = new FileOutputStream(directory + "/private.key");){
            publicOut.write(Base64.getEncoder().encode(publicSpec.getEncoded()));
            privateOut.write(Base64.getEncoder().encode(privateSpec.getEncoded()));
        }
    }

    public static byte[] readB64File(File directory, String name) throws IOException {
        File f = new File(directory, name);
        byte[] contents = Files.readAllBytes(f.toPath());
        String strContents = new String(contents, StandardCharsets.US_ASCII);
        strContents = strContents.trim();
        try {
            return Base64.getDecoder().decode(strContents);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Base64 decoding exception: This is probably due to a corrupted file, but in case it isn't, here is a b64 representation of what we read: " + new String(Base64.getEncoder().encode(contents), StandardCharsets.UTF_8), e);
        }
    }

    public static KeyPair load(File directory) throws Exception {
        byte[] encodedPublicKey = RSAIO.readB64File(directory, "public.key");
        byte[] encodedPrivateKey = RSAIO.readB64File(directory, "private.key");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedPublicKey);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        return new KeyPair(publicKey, privateKey);
    }
}

