/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.net.protocol;

import com.vexsoftware.votifier.io.netty.buffer.ByteBuf;
import com.vexsoftware.votifier.io.netty.channel.ChannelHandlerContext;
import com.vexsoftware.votifier.io.netty.handler.codec.ByteToMessageDecoder;
import com.vexsoftware.votifier.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import com.vexsoftware.votifier.io.netty.handler.codec.string.StringDecoder;
import com.vexsoftware.votifier.io.netty.handler.codec.string.StringEncoder;
import com.vexsoftware.votifier.net.VotifierSession;
import com.vexsoftware.votifier.net.protocol.VotifierProtocol1Decoder;
import com.vexsoftware.votifier.net.protocol.VotifierProtocol2Decoder;
import com.vexsoftware.votifier.util.QuietException;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class VotifierProtocolDifferentiator
extends ByteToMessageDecoder {
    private static final QuietException V2_ONLY = new QuietException("This server only accepts well-formed Votifier v2 packets.");
    private static final short PROTOCOL_2_MAGIC = 29498;
    private final boolean testMode;
    private final boolean allowv1;

    public VotifierProtocolDifferentiator(boolean testMode, boolean allowv1) {
        this.testMode = testMode;
        this.allowv1 = allowv1;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> list) throws Exception {
        int readable = buf.readableBytes();
        if (readable < 2) {
            return;
        }
        short readMagic = buf.getShort(0);
        VotifierSession session = ctx.channel().attr(VotifierSession.KEY).get();
        if (readMagic == 29498) {
            session.setVersion(VotifierSession.ProtocolVersion.TWO);
            if (!this.testMode) {
                ctx.pipeline().addAfter("protocolDifferentiator", "protocol2LengthDecoder", new LengthFieldBasedFrameDecoder(1024, 2, 2, 0, 4));
                ctx.pipeline().addAfter("protocol2LengthDecoder", "protocol2StringDecoder", new StringDecoder(StandardCharsets.UTF_8));
                ctx.pipeline().addAfter("protocol2StringDecoder", "protocol2VoteDecoder", new VotifierProtocol2Decoder());
                ctx.pipeline().addAfter("protocol2VoteDecoder", "protocol2StringEncoder", new StringEncoder(StandardCharsets.UTF_8));
                ctx.pipeline().remove(this);
            }
        } else {
            if (!this.allowv1) {
                throw V2_ONLY;
            }
            session.setVersion(VotifierSession.ProtocolVersion.ONE);
            if (!this.testMode) {
                ctx.pipeline().addAfter("protocolDifferentiator", "protocol1Handler", new VotifierProtocol1Decoder());
                ctx.pipeline().remove(this);
            }
        }
    }
}

