/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.net.protocol;

import com.vexsoftware.votifier.google.gson.JsonObject;
import com.vexsoftware.votifier.io.netty.channel.ChannelHandlerContext;
import com.vexsoftware.votifier.io.netty.handler.codec.CorruptedFrameException;
import com.vexsoftware.votifier.io.netty.handler.codec.MessageToMessageDecoder;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.net.VotifierSession;
import com.vexsoftware.votifier.platform.VotifierPlugin;
import com.vexsoftware.votifier.util.GsonInst;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class VotifierProtocol2Decoder
extends MessageToMessageDecoder<String> {
    private static final SecureRandom RANDOM = new SecureRandom();

    @Override
    protected void decode(ChannelHandlerContext ctx, String s, List<Object> list) throws Exception {
        JsonObject voteMessage = GsonInst.gson.fromJson(s, JsonObject.class);
        VotifierSession session = ctx.channel().attr(VotifierSession.KEY).get();
        String payload = voteMessage.get("payload").getAsString();
        JsonObject votePayload = GsonInst.gson.fromJson(payload, JsonObject.class);
        if (!votePayload.get("challenge").getAsString().equals(session.getChallenge())) {
            throw new CorruptedFrameException("Challenge is not valid");
        }
        VotifierPlugin plugin = ctx.channel().attr(VotifierPlugin.KEY).get();
        Key key = plugin.getTokens().get(votePayload.get("serviceName").getAsString());
        if (key == null && (key = plugin.getTokens().get("default")) == null) {
            throw new RuntimeException("Unknown service '" + votePayload.get("serviceName").getAsString() + "'");
        }
        String sigHash = voteMessage.get("signature").getAsString();
        byte[] sigBytes = Base64.getDecoder().decode(sigHash);
        if (!this.hmacEqual(sigBytes, payload.getBytes(StandardCharsets.UTF_8), key)) {
            throw new CorruptedFrameException("Signature is not valid (invalid token?)");
        }
        if (votePayload.has("uuid")) {
            UUID.fromString(votePayload.get("uuid").getAsString());
        }
        if (votePayload.get("username").getAsString().length() > 16) {
            throw new CorruptedFrameException("Username too long");
        }
        Vote vote = new Vote(votePayload);
        list.add(vote);
        ctx.pipeline().remove(this);
    }

    private boolean hmacEqual(byte[] sig, byte[] message, Key key) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(key);
        byte[] calculatedSig = mac.doFinal(message);
        byte[] randomKey = new byte[32];
        RANDOM.nextBytes(randomKey);
        Mac mac2 = Mac.getInstance("HmacSHA256");
        mac2.init(new SecretKeySpec(randomKey, "HmacSHA256"));
        byte[] clientSig = mac2.doFinal(sig);
        mac2.reset();
        byte[] realSig = mac2.doFinal(calculatedSig);
        return MessageDigest.isEqual(clientSig, realSig);
    }
}

