/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.net.protocol;

import com.vexsoftware.votifier.io.netty.buffer.ByteBuf;
import com.vexsoftware.votifier.io.netty.buffer.ByteBufUtil;
import com.vexsoftware.votifier.io.netty.channel.ChannelHandlerContext;
import com.vexsoftware.votifier.io.netty.handler.codec.ByteToMessageDecoder;
import com.vexsoftware.votifier.io.netty.handler.codec.CorruptedFrameException;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.net.protocol.v1crypto.RSA;
import com.vexsoftware.votifier.platform.VotifierPlugin;
import com.vexsoftware.votifier.util.QuietException;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class VotifierProtocol1Decoder
extends ByteToMessageDecoder {
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> list) throws Exception {
        if (!ctx.channel().isActive()) {
            buf.skipBytes(buf.readableBytes());
            return;
        }
        if (buf.readableBytes() < 256) {
            return;
        }
        if (buf.readableBytes() > 256) {
            throw new QuietException("Could not decrypt data from " + ctx.channel().remoteAddress() + " as it is too long. Attack?");
        }
        byte[] block = ByteBufUtil.getBytes(buf);
        buf.skipBytes(buf.readableBytes());
        VotifierPlugin plugin = ctx.channel().attr(VotifierPlugin.KEY).get();
        try {
            block = RSA.decrypt(block, plugin.getProtocolV1Key().getPrivate());
        }
        catch (Exception e) {
            if (plugin.isDebug()) {
                throw new CorruptedFrameException("Could not decrypt data from " + ctx.channel().remoteAddress() + ". Make sure the public key on the list is correct.", e);
            }
            throw new QuietException("Could not decrypt data from " + ctx.channel().remoteAddress() + ". Make sure the public key on the list is correct.");
        }
        String all = new String(block, StandardCharsets.US_ASCII);
        String[] split = all.split("\n");
        if (split.length < 5) {
            throw new QuietException("Not enough fields specified in vote. This is not a NuVotifier issue. Got " + split.length + " fields, but needed 5.");
        }
        if (!split[0].equals("VOTE")) {
            throw new QuietException("The VOTE opcode was not present. This is not a NuVotifier issue, but a bug with the server list.");
        }
        Vote vote = new Vote(split[1], split[2], split[3], split[4]);
        list.add(vote);
        ctx.pipeline().remove(this);
    }
}

