/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.net.protocol;

import com.vexsoftware.votifier.VoteHandler;
import com.vexsoftware.votifier.google.gson.JsonObject;
import com.vexsoftware.votifier.io.netty.channel.ChannelFutureListener;
import com.vexsoftware.votifier.io.netty.channel.ChannelHandler;
import com.vexsoftware.votifier.io.netty.channel.ChannelHandlerContext;
import com.vexsoftware.votifier.io.netty.channel.SimpleChannelInboundHandler;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.net.VotifierSession;
import com.vexsoftware.votifier.util.GsonInst;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler.Sharable
public class VoteInboundHandler
extends SimpleChannelInboundHandler<Vote> {
    private final VoteHandler handler;
    private final AtomicLong lastError;
    private final AtomicLong errorsSent;

    public VoteInboundHandler(VoteHandler handler) {
        this.handler = handler;
        this.lastError = new AtomicLong();
        this.errorsSent = new AtomicLong();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Vote vote) throws Exception {
        VotifierSession session = ctx.channel().attr(VotifierSession.KEY).get();
        this.handler.onVoteReceived(vote, session.getVersion(), ctx.channel().remoteAddress().toString());
        session.completeVote();
        if (session.getVersion() == VotifierSession.ProtocolVersion.ONE) {
            ctx.close();
        } else {
            JsonObject object = new JsonObject();
            object.addProperty("status", "ok");
            ctx.writeAndFlush(GsonInst.gson.toJson(object) + "\r\n").addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        VotifierSession session = ctx.channel().attr(VotifierSession.KEY).get();
        String remoteAddr = ctx.channel().remoteAddress().toString();
        boolean hasCompletedVote = session.hasCompletedVote();
        if (session.getVersion() == VotifierSession.ProtocolVersion.TWO) {
            JsonObject object = new JsonObject();
            object.addProperty("status", "error");
            object.addProperty("cause", cause.getClass().getSimpleName());
            object.addProperty("error", cause.getMessage());
            ctx.writeAndFlush(GsonInst.gson.toJson(object) + "\r\n").addListener(ChannelFutureListener.CLOSE);
        } else {
            ctx.close();
        }
        if (!this.willThrottleErrorLogging()) {
            this.handler.onError(cause, hasCompletedVote, remoteAddr);
        }
    }

    private boolean willThrottleErrorLogging() {
        long now;
        long lastErrorAt = this.lastError.get();
        if (lastErrorAt + 2000L >= (now = System.currentTimeMillis())) {
            return this.errorsSent.incrementAndGet() >= 5L;
        }
        this.lastError.set(now);
        this.errorsSent.set(0L);
        return false;
    }
}

