/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.net;

import com.vexsoftware.votifier.io.netty.util.AttributeKey;
import com.vexsoftware.votifier.util.TokenUtil;

public class VotifierSession {
    public static final AttributeKey<VotifierSession> KEY = AttributeKey.valueOf("votifier_session");
    private ProtocolVersion version = ProtocolVersion.UNKNOWN;
    private final String challenge = TokenUtil.newToken();
    private boolean hasCompletedVote = false;

    public void setVersion(ProtocolVersion version) {
        if (this.version != ProtocolVersion.UNKNOWN) {
            throw new IllegalStateException("Protocol version already switched");
        }
        this.version = version;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public void completeVote() {
        if (this.hasCompletedVote) {
            throw new IllegalStateException("Protocol completed vote twice!");
        }
        this.hasCompletedVote = true;
    }

    public boolean hasCompletedVote() {
        return this.hasCompletedVote;
    }

    public static enum ProtocolVersion {
        UNKNOWN("unknown"),
        ONE("protocol v1"),
        TWO("protocol v2"),
        TEST("test");

        public final String humanReadable;

        private ProtocolVersion(String hr) {
            this.humanReadable = hr;
        }
    }
}

