/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.net;

import com.vexsoftware.votifier.io.netty.bootstrap.Bootstrap;
import com.vexsoftware.votifier.io.netty.bootstrap.ServerBootstrap;
import com.vexsoftware.votifier.io.netty.channel.Channel;
import com.vexsoftware.votifier.io.netty.channel.ChannelHandler;
import com.vexsoftware.votifier.io.netty.channel.ChannelInitializer;
import com.vexsoftware.votifier.io.netty.channel.EventLoopGroup;
import com.vexsoftware.votifier.io.netty.channel.epoll.Epoll;
import com.vexsoftware.votifier.io.netty.channel.epoll.EpollEventLoopGroup;
import com.vexsoftware.votifier.io.netty.channel.epoll.EpollServerSocketChannel;
import com.vexsoftware.votifier.io.netty.channel.epoll.EpollSocketChannel;
import com.vexsoftware.votifier.io.netty.channel.nio.NioEventLoopGroup;
import com.vexsoftware.votifier.io.netty.channel.socket.SocketChannel;
import com.vexsoftware.votifier.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.vexsoftware.votifier.io.netty.channel.socket.nio.NioSocketChannel;
import com.vexsoftware.votifier.io.netty.util.concurrent.FastThreadLocalThread;
import com.vexsoftware.votifier.net.VotifierSession;
import com.vexsoftware.votifier.net.protocol.VoteInboundHandler;
import com.vexsoftware.votifier.net.protocol.VotifierGreetingHandler;
import com.vexsoftware.votifier.net.protocol.VotifierProtocolDifferentiator;
import com.vexsoftware.votifier.platform.VotifierPlugin;
import com.vexsoftware.votifier.support.forwarding.cache.VoteCache;
import com.vexsoftware.votifier.support.forwarding.proxy.ProxyForwardingVoteSource;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class VotifierServerBootstrap {
    private static final boolean USE_EPOLL = Epoll.isAvailable();
    private final String host;
    private final int port;
    private final EventLoopGroup bossLoopGroup;
    private final EventLoopGroup eventLoopGroup;
    private final VotifierPlugin plugin;
    private final boolean v1Disable;
    private Channel serverChannel;

    public VotifierServerBootstrap(String host, int port, VotifierPlugin plugin, boolean v1Disable) {
        this.host = host;
        this.port = port;
        this.plugin = plugin;
        this.v1Disable = v1Disable;
        if (USE_EPOLL) {
            this.bossLoopGroup = new EpollEventLoopGroup(1, VotifierServerBootstrap.createThreadFactory("Votifier epoll boss"));
            this.eventLoopGroup = new EpollEventLoopGroup(3, VotifierServerBootstrap.createThreadFactory("Votifier epoll worker"));
            plugin.getPluginLogger().info("Using epoll transport to accept votes.");
        } else {
            this.bossLoopGroup = new NioEventLoopGroup(1, VotifierServerBootstrap.createThreadFactory("Votifier NIO boss"));
            this.eventLoopGroup = new NioEventLoopGroup(3, VotifierServerBootstrap.createThreadFactory("Votifier NIO worker"));
            plugin.getPluginLogger().info("Using NIO transport to accept votes.");
        }
    }

    private static ThreadFactory createThreadFactory(String name) {
        return runnable -> {
            FastThreadLocalThread thread = new FastThreadLocalThread(runnable, name);
            thread.setDaemon(true);
            return thread;
        };
    }

    public void start(Consumer<Throwable> error) {
        Objects.requireNonNull(error, "error");
        final VoteInboundHandler voteInboundHandler = new VoteInboundHandler(this.plugin);
        ((ServerBootstrap)new ServerBootstrap().channel(USE_EPOLL ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).group(this.bossLoopGroup, this.eventLoopGroup).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel channel) {
                channel.attr(VotifierSession.KEY).set(new VotifierSession());
                channel.attr(VotifierPlugin.KEY).set(VotifierServerBootstrap.this.plugin);
                channel.pipeline().addLast("greetingHandler", (ChannelHandler)VotifierGreetingHandler.INSTANCE);
                channel.pipeline().addLast("protocolDifferentiator", (ChannelHandler)new VotifierProtocolDifferentiator(false, !VotifierServerBootstrap.this.v1Disable));
                channel.pipeline().addLast("voteHandler", (ChannelHandler)voteInboundHandler);
            }
        }).bind(this.host, this.port).addListener(future -> {
            if (future.isSuccess()) {
                this.serverChannel = future.channel();
                this.plugin.getPluginLogger().info("Votifier enabled on socket " + this.serverChannel.localAddress() + ".");
                error.accept(null);
            } else {
                SocketAddress socketAddress = future.channel().localAddress();
                if (socketAddress == null) {
                    socketAddress = new InetSocketAddress(this.host, this.port);
                }
                this.plugin.getPluginLogger().error("Votifier was not able to bind to " + socketAddress.toString(), future.cause(), new Object[0]);
                error.accept(future.cause());
            }
        });
    }

    private Bootstrap client() {
        return (Bootstrap)((Bootstrap)new Bootstrap().channel(USE_EPOLL ? EpollSocketChannel.class : NioSocketChannel.class)).group(this.eventLoopGroup);
    }

    public ProxyForwardingVoteSource createForwardingSource(List<ProxyForwardingVoteSource.BackendServer> backendServers, VoteCache voteCache) {
        return new ProxyForwardingVoteSource(this.plugin, this::client, backendServers, voteCache);
    }

    public void shutdown() {
        if (this.serverChannel != null) {
            try {
                this.serverChannel.close().syncUninterruptibly();
            }
            catch (Exception e) {
                this.plugin.getPluginLogger().error("Unable to shutdown server channel", e, new Object[0]);
            }
        }
        this.eventLoopGroup.shutdownGracefully();
        this.bossLoopGroup.shutdownGracefully();
        try {
            this.bossLoopGroup.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            this.eventLoopGroup.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

