/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.model;

import com.vexsoftware.votifier.google.gson.JsonElement;
import com.vexsoftware.votifier.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Base64;

public class Vote {
    private String serviceName;
    private String username;
    private String address;
    private String timeStamp;
    private byte[] additionalData;

    @Deprecated
    public Vote() {
    }

    public Vote(String serviceName, String username, String address, String timeStamp) {
        this.serviceName = serviceName;
        this.username = username;
        this.address = address;
        this.timeStamp = timeStamp;
        this.additionalData = null;
    }

    public Vote(String serviceName, String username, String address, String timeStamp, byte[] additionalData) {
        this.serviceName = serviceName;
        this.username = username;
        this.address = address;
        this.timeStamp = timeStamp;
        this.additionalData = additionalData == null ? null : (byte[])additionalData.clone();
    }

    public Vote(Vote vote) {
        this(vote.getServiceName(), vote.getUsername(), vote.getAddress(), vote.getTimeStamp(), vote.getAdditionalData() == null ? null : (byte[])vote.getAdditionalData().clone());
    }

    private static String getTimestamp(JsonElement object) {
        try {
            return Long.toString(object.getAsLong());
        }
        catch (Exception e) {
            return object.getAsString();
        }
    }

    public Vote(JsonObject jsonObject) {
        this(jsonObject.get("serviceName").getAsString(), jsonObject.get("username").getAsString(), jsonObject.get("address").getAsString(), Vote.getTimestamp(jsonObject.get("timestamp")));
        if (jsonObject.has("additionalData")) {
            this.additionalData = Base64.getDecoder().decode(jsonObject.get("additionalData").getAsString());
        }
    }

    public String toString() {
        String data = this.additionalData == null ? "null" : Base64.getEncoder().encodeToString(this.additionalData);
        return "Vote (from:" + this.serviceName + " username:" + this.username + " address:" + this.address + " timeStamp:" + this.timeStamp + " additionalData:" + data + ")";
    }

    @Deprecated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Deprecated
    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    @Deprecated
    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    @Deprecated
    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public byte[] getAdditionalData() {
        return this.additionalData == null ? null : (byte[])this.additionalData.clone();
    }

    public JsonObject serialize() {
        JsonObject ret = new JsonObject();
        ret.addProperty("serviceName", this.serviceName);
        ret.addProperty("username", this.username);
        ret.addProperty("address", this.address);
        ret.addProperty("timestamp", this.timeStamp);
        if (this.additionalData != null) {
            ret.addProperty("additionalData", Base64.getEncoder().encodeToString(this.additionalData));
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vote)) {
            return false;
        }
        Vote vote = (Vote)o;
        if (!this.serviceName.equals(vote.serviceName)) {
            return false;
        }
        if (!this.username.equals(vote.username)) {
            return false;
        }
        if (!this.address.equals(vote.address)) {
            return false;
        }
        if (!this.timeStamp.equals(vote.timeStamp)) {
            return false;
        }
        return Arrays.equals(this.additionalData, vote.additionalData);
    }

    public int hashCode() {
        int result = this.serviceName.hashCode();
        result = 31 * result + this.username.hashCode();
        result = 31 * result + this.address.hashCode();
        result = 31 * result + this.timeStamp.hashCode();
        return result;
    }
}

