/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.io.netty.handler.codec.base64;

import com.vexsoftware.votifier.io.netty.buffer.ByteBuf;
import com.vexsoftware.votifier.io.netty.channel.ChannelHandler;
import com.vexsoftware.votifier.io.netty.channel.ChannelHandlerContext;
import com.vexsoftware.votifier.io.netty.handler.codec.MessageToMessageEncoder;
import com.vexsoftware.votifier.io.netty.handler.codec.base64.Base64;
import com.vexsoftware.votifier.io.netty.handler.codec.base64.Base64Dialect;
import com.vexsoftware.votifier.io.netty.util.internal.ObjectUtil;
import java.util.List;

@ChannelHandler.Sharable
public class Base64Encoder
extends MessageToMessageEncoder<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        this.dialect = ObjectUtil.checkNotNull(dialect, "dialect");
        this.breakLines = breakLines;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.encode(msg, msg.readerIndex(), msg.readableBytes(), this.breakLines, this.dialect));
    }
}

