/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.bungee;

import com.vexsoftware.votifier.bungee.BungeeBackendServer;
import com.vexsoftware.votifier.bungee.NuVotifier;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.platform.BackendServer;
import com.vexsoftware.votifier.support.forwarding.AbstractPluginMessagingForwardingSource;
import com.vexsoftware.votifier.support.forwarding.ServerFilter;
import com.vexsoftware.votifier.support.forwarding.cache.VoteCache;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public final class OnlineForwardPluginMessagingForwardingSource
extends AbstractPluginMessagingForwardingSource
implements Listener {
    private final String fallbackServer;

    public OnlineForwardPluginMessagingForwardingSource(String channel, NuVotifier nuVotifier, ServerFilter serverFilter, VoteCache cache, String fallbackServer, int dumpRate) {
        super(channel, serverFilter, nuVotifier, cache, dumpRate);
        this.fallbackServer = fallbackServer;
        ProxyServer.getInstance().getPluginManager().registerListener((Plugin)nuVotifier, (Listener)this);
    }

    @Override
    public void forward(Vote v) {
        ProxiedPlayer p = ProxyServer.getInstance().getPlayer(v.getUsername());
        if (p != null && p.getServer() != null && this.serverFilter.isAllowed(p.getServer().getInfo().getName()) && this.forwardSpecific((BackendServer)new BungeeBackendServer(p.getServer().getInfo()), v)) {
            if (this.plugin.isDebug()) {
                this.plugin.getPluginLogger().info("Successfully forwarded vote " + v + " to server " + p.getServer().getInfo().getName());
            }
            return;
        }
        ServerInfo serverInfo = (ServerInfo)ProxyServer.getInstance().getServers().get(this.fallbackServer);
        if (serverInfo == null) {
            this.attemptToAddToPlayerCache(v, v.getUsername());
        } else if (!this.forwardSpecific((BackendServer)new BungeeBackendServer(serverInfo), v)) {
            this.attemptToAddToCache(v, this.fallbackServer);
        }
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent e) {
        if (e.getTag().equals(this.channel)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onServerConnected(ServerConnectedEvent e) {
        BungeeBackendServer server = new BungeeBackendServer(e.getServer().getInfo());
        this.handlePlayerSwitch(server, e.getPlayer().getName());
        this.onServerConnect(server);
    }
}

