/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier.bungee;

import com.vexsoftware.votifier.VoteHandler;
import com.vexsoftware.votifier.bungee.BungeeBackendServer;
import com.vexsoftware.votifier.bungee.BungeeScheduler;
import com.vexsoftware.votifier.bungee.OnlineForwardPluginMessagingForwardingSource;
import com.vexsoftware.votifier.bungee.PluginMessagingForwardingSource;
import com.vexsoftware.votifier.bungee.ReloadListener;
import com.vexsoftware.votifier.bungee.cmd.NVReloadCmd;
import com.vexsoftware.votifier.bungee.cmd.TestVoteCmd;
import com.vexsoftware.votifier.bungee.events.VotifierEvent;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.net.VotifierServerBootstrap;
import com.vexsoftware.votifier.net.VotifierSession;
import com.vexsoftware.votifier.net.protocol.v1crypto.RSAIO;
import com.vexsoftware.votifier.net.protocol.v1crypto.RSAKeygen;
import com.vexsoftware.votifier.platform.BackendServer;
import com.vexsoftware.votifier.platform.JavaUtilLogger;
import com.vexsoftware.votifier.platform.LoggingAdapter;
import com.vexsoftware.votifier.platform.ProxyVotifierPlugin;
import com.vexsoftware.votifier.platform.scheduler.VotifierScheduler;
import com.vexsoftware.votifier.support.forwarding.ForwardingVoteSource;
import com.vexsoftware.votifier.support.forwarding.ServerFilter;
import com.vexsoftware.votifier.support.forwarding.cache.FileVoteCache;
import com.vexsoftware.votifier.support.forwarding.cache.MemoryVoteCache;
import com.vexsoftware.votifier.support.forwarding.cache.VoteCache;
import com.vexsoftware.votifier.support.forwarding.proxy.ProxyForwardingVoteSource;
import com.vexsoftware.votifier.util.IOUtil;
import com.vexsoftware.votifier.util.KeyCreator;
import com.vexsoftware.votifier.util.TokenUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.Key;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class NuVotifier
extends Plugin
implements VoteHandler,
ProxyVotifierPlugin {
    private VotifierServerBootstrap bootstrap;
    private KeyPair keyPair;
    private boolean debug;
    private Map<String, Key> tokens = new HashMap<String, Key>();
    private ForwardingVoteSource forwardingMethod;
    private VotifierScheduler scheduler;
    private LoggingAdapter pluginLogger;

    private void loadAndBind() {
        boolean disablev1;
        Configuration configuration;
        Object token;
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdir()) {
            throw new RuntimeException("Unable to create the plugin data folder " + this.getDataFolder());
        }
        File config = new File(this.getDataFolder(), "config.yml");
        File rsaDirectory = new File(this.getDataFolder(), "rsa");
        if (!config.exists()) {
            try {
                this.getLogger().info("Configuring Votifier for the first time...");
                if (!config.createNewFile()) {
                    throw new IOException("Unable to create the config file at " + config);
                }
                String cfgStr = new String(IOUtil.readAllBytes(this.getResourceAsStream("bungeeConfig.yml")), StandardCharsets.UTF_8);
                token = TokenUtil.newToken();
                cfgStr = cfgStr.replace("%default_token%", (CharSequence)token);
                Files.copy(new ByteArrayInputStream(cfgStr.getBytes(StandardCharsets.UTF_8)), config.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.getLogger().info("------------------------------------------------------------------------------");
                this.getLogger().info("Assigning NuVotifier to listen on port 8192. If you are hosting BungeeCord on a");
                this.getLogger().info("shared server please check with your hosting provider to verify that this port");
                this.getLogger().info("is available for your use. Chances are that your hosting provider will assign");
                this.getLogger().info("a different port, which you need to specify in config.yml");
                this.getLogger().info("------------------------------------------------------------------------------");
                this.getLogger().info("Assigning NuVotifier to listen to interface 0.0.0.0. This is usually alright,");
                this.getLogger().info("however, if you want NuVotifier to only listen to one interface for security ");
                this.getLogger().info("reasons (or you use a shared host), you may change this in the config.yml.");
                this.getLogger().info("------------------------------------------------------------------------------");
                this.getLogger().info("Your default Votifier token is " + (String)token + ".");
                this.getLogger().info("You will need to provide this token when you submit your server to a voting");
                this.getLogger().info("list.");
                this.getLogger().info("------------------------------------------------------------------------------");
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create configuration file", ex);
            }
        }
        try {
            configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(config);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load configuration", e);
        }
        try {
            if (!rsaDirectory.exists()) {
                if (!rsaDirectory.mkdir()) {
                    throw new RuntimeException("Unable to create the RSA key folder " + rsaDirectory);
                }
                this.keyPair = RSAKeygen.generate(2048);
                RSAIO.save(rsaDirectory, this.keyPair);
            } else {
                this.keyPair = RSAIO.load(rsaDirectory);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error reading RSA tokens", ex);
        }
        Configuration tokenSection = configuration.getSection("tokens");
        if (configuration.get("tokens") != null) {
            for (String s : tokenSection.getKeys()) {
                this.tokens.put(s, KeyCreator.createKeyFrom(tokenSection.getString(s)));
                this.getLogger().info("Loaded token for website: " + s);
            }
        } else {
            token = TokenUtil.newToken();
            configuration.set("tokens", Collections.singletonMap("default", token));
            this.tokens.put("default", KeyCreator.createKeyFrom((String)token));
            try {
                ConfigurationProvider.getProvider(YamlConfiguration.class).save(configuration, config);
            }
            catch (IOException e) {
                throw new RuntimeException("Error generating Votifier token", e);
            }
            this.getLogger().info("------------------------------------------------------------------------------");
            this.getLogger().info("No tokens were found in your configuration, so we've generated one for you.");
            this.getLogger().info("Your default Votifier token is " + (String)token + ".");
            this.getLogger().info("You will need to provide this token when you submit your server to a voting");
            this.getLogger().info("list.");
            this.getLogger().info("------------------------------------------------------------------------------");
        }
        String host = configuration.getString("host", "0.0.0.0");
        int port = configuration.getInt("port", 8192);
        this.debug = configuration.get("quiet") != null ? !configuration.getBoolean("quiet") : configuration.getBoolean("debug", true);
        if (!this.debug) {
            this.getLogger().info("QUIET mode enabled!");
        }
        if (disablev1 = configuration.getBoolean("disable-v1-protocol")) {
            this.getLogger().info("------------------------------------------------------------------------------");
            this.getLogger().info("Votifier protocol v1 parsing has been disabled. Most voting websites do not");
            this.getLogger().info("currently support the modern Votifier protocol in NuVotifier.");
            this.getLogger().info("------------------------------------------------------------------------------");
        }
        FutureTask<Object> initTask = new FutureTask<Object>(Executors.callable(() -> {
            this.bootstrap = new VotifierServerBootstrap(host, port, this, disablev1);
            this.bootstrap.start(err -> {});
        }));
        this.getProxy().getScheduler().runAsync((Plugin)this, initTask);
        try {
            initTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to start server", e);
        }
        Configuration fwdCfg = configuration.getSection("forwarding");
        String fwdMethod = fwdCfg.getString("method", "none").toLowerCase();
        if ("none".equals(fwdMethod)) {
            this.getLogger().info("Method none selected for vote forwarding: Votes will not be forwarded to backend servers.");
        } else if ("pluginmessaging".equals(fwdMethod)) {
            String channel = fwdCfg.getString("pluginMessaging.channel", "NuVotifier");
            String cacheMethod = fwdCfg.getString("pluginMessaging.cache", "file").toLowerCase();
            MemoryVoteCache voteCache = null;
            if ("none".equals(cacheMethod)) {
                this.getLogger().info("Vote cache none selected for caching: votes that cannot be immediately delivered will be lost.");
            } else if ("memory".equals(cacheMethod)) {
                voteCache = new MemoryVoteCache(this, fwdCfg.getInt("pluginMessaging.memory.cacheTime", -1));
                this.getLogger().info("Using in-memory cache for votes that are not able to be delivered.");
            } else if ("file".equals(cacheMethod)) {
                try {
                    voteCache = new FileVoteCache(this, new File(this.getDataFolder(), fwdCfg.getString("pluginMessaging.file.name")), fwdCfg.getInt("pluginMessaging.file.cacheTime", -1));
                }
                catch (IOException e) {
                    this.getLogger().log(Level.SEVERE, "Unload to load file cache. Votes will be lost!", e);
                }
            }
            int dumpRate = fwdCfg.getInt("pluginMessaging.dumpRate", 5);
            ServerFilter filter = new ServerFilter(fwdCfg.getStringList("pluginMessaging.excludedServers"), fwdCfg.getBoolean("pluginMessaging.whitelist", false));
            if (!fwdCfg.getBoolean("pluginMessaging.onlySendToJoinedServer")) {
                try {
                    this.forwardingMethod = new PluginMessagingForwardingSource(channel, filter, this, (VoteCache)voteCache, dumpRate);
                    this.getLogger().info("Forwarding votes over PluginMessaging channel '" + channel + "' for vote forwarding!");
                }
                catch (RuntimeException e) {
                    this.getLogger().log(Level.SEVERE, "NuVotifier could not set up PluginMessaging for vote forwarding!", e);
                }
            } else {
                try {
                    String fallbackServer = fwdCfg.getString("pluginMessaging.joinedServerFallback", null);
                    if (fallbackServer != null && fallbackServer.isEmpty()) {
                        fallbackServer = null;
                    }
                    this.forwardingMethod = new OnlineForwardPluginMessagingForwardingSource(channel, this, filter, voteCache, fallbackServer, dumpRate);
                    this.getLogger().info("Forwarding votes over PluginMessaging channel '" + channel + "' for vote forwarding for online players!");
                }
                catch (RuntimeException e) {
                    this.getLogger().log(Level.SEVERE, "NuVotifier could not set up PluginMessaging for vote forwarding!", e);
                }
            }
        } else if ("proxy".equals(fwdMethod)) {
            Configuration serverSection = fwdCfg.getSection("proxy");
            ArrayList<ProxyForwardingVoteSource.BackendServer> serverList = new ArrayList<ProxyForwardingVoteSource.BackendServer>();
            for (String s : serverSection.getKeys()) {
                InetAddress address;
                Configuration section = serverSection.getSection(s);
                try {
                    address = InetAddress.getByName(section.getString("address"));
                }
                catch (UnknownHostException e) {
                    this.getLogger().info("Address " + section.getString("address") + " couldn't be looked up. Ignoring!");
                    continue;
                }
                Key token2 = null;
                try {
                    token2 = KeyCreator.createKeyFrom(section.getString("token", section.getString("key")));
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().log(Level.SEVERE, "An exception occurred while attempting to add proxy target '" + s + "' - maybe your token is wrong? Votes will not be forwarded to this server!", e);
                }
                if (token2 == null) continue;
                ProxyForwardingVoteSource.BackendServer server = new ProxyForwardingVoteSource.BackendServer(s, new InetSocketAddress(address, section.getInt("port")), token2);
                serverList.add(server);
            }
            this.forwardingMethod = this.bootstrap.createForwardingSource(serverList, null);
            this.getLogger().info("Forwarding votes from this NuVotifier instance to another NuVotifier server.");
        } else {
            this.getLogger().severe("No vote forwarding method '" + fwdMethod + "' known. Defaulting to noop implementation.");
        }
    }

    public void onEnable() {
        this.scheduler = new BungeeScheduler(this);
        this.pluginLogger = new JavaUtilLogger(this.getLogger());
        PluginManager pm = ProxyServer.getInstance().getPluginManager();
        pm.registerCommand((Plugin)this, (Command)new NVReloadCmd(this));
        pm.registerCommand((Plugin)this, (Command)new TestVoteCmd(this));
        pm.registerListener((Plugin)this, (Listener)new ReloadListener(this));
        this.loadAndBind();
    }

    private void halt() {
        if (this.bootstrap != null) {
            this.bootstrap.shutdown();
            this.bootstrap = null;
        }
        if (this.forwardingMethod != null) {
            this.forwardingMethod.halt();
            this.forwardingMethod = null;
        }
    }

    public boolean reload() {
        try {
            this.halt();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "On halt, an exception was thrown. This may be fine!", ex);
        }
        try {
            this.loadAndBind();
            this.getLogger().info("Reload was successful.");
            return true;
        }
        catch (Exception ex) {
            try {
                this.halt();
                this.getLogger().log(Level.SEVERE, "On reload, there was a problem with the configuration. Votifier currently does nothing!", ex);
            }
            catch (Exception ex2) {
                this.getLogger().log(Level.SEVERE, "On reload, there was a problem loading, and we could not re-halt the server. Votifier is in an unstable state!", ex);
                this.getLogger().log(Level.SEVERE, "(halt exception)", ex2);
            }
            return false;
        }
    }

    public void onDisable() {
        this.halt();
        this.getLogger().info("Votifier disabled.");
    }

    @Override
    public void onVoteReceived(Vote vote, VotifierSession.ProtocolVersion protocolVersion, String remoteAddress) {
        if (this.debug) {
            if (protocolVersion == VotifierSession.ProtocolVersion.ONE) {
                this.getLogger().info("Got a protocol v1 vote record from " + remoteAddress + " -> " + vote);
            } else {
                this.getLogger().info("Got a protocol v2 vote record from " + remoteAddress + " -> " + vote);
            }
        }
        this.getProxy().getScheduler().runAsync((Plugin)this, () -> this.getProxy().getPluginManager().callEvent((Event)new VotifierEvent(vote)));
        if (this.forwardingMethod != null) {
            this.getProxy().getScheduler().runAsync((Plugin)this, () -> this.forwardingMethod.forward(vote));
        }
    }

    @Override
    public void onError(Throwable throwable, boolean alreadyHandledVote, String remoteAddress) {
        if (this.debug) {
            if (alreadyHandledVote) {
                this.getLogger().log(Level.SEVERE, "Vote processed, however an exception occurred with a vote from " + remoteAddress, throwable);
            } else {
                this.getLogger().log(Level.SEVERE, "Unable to process vote from " + remoteAddress, throwable);
            }
        } else if (!alreadyHandledVote) {
            this.getLogger().log(Level.SEVERE, "Unable to process vote from " + remoteAddress);
        }
    }

    @Override
    public Map<String, Key> getTokens() {
        return this.tokens;
    }

    @Override
    public KeyPair getProtocolV1Key() {
        return this.keyPair;
    }

    @Override
    public LoggingAdapter getPluginLogger() {
        return this.pluginLogger;
    }

    @Override
    public VotifierScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public Collection<BackendServer> getAllBackendServers() {
        return this.getProxy().getServers().values().stream().map(BungeeBackendServer::new).collect(Collectors.toList());
    }

    @Override
    public Optional<BackendServer> getServer(String name) {
        ServerInfo info = this.getProxy().getServerInfo(name);
        return Optional.ofNullable(info).map(BungeeBackendServer::new);
    }
}

