/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier;

import com.vexsoftware.votifier.BukkitScheduler;
import com.vexsoftware.votifier.VoteHandler;
import com.vexsoftware.votifier.cmd.NVReloadCmd;
import com.vexsoftware.votifier.cmd.TestVoteCmd;
import com.vexsoftware.votifier.forwarding.BukkitPluginMessagingForwardingSink;
import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.model.VotifierEvent;
import com.vexsoftware.votifier.net.VotifierServerBootstrap;
import com.vexsoftware.votifier.net.VotifierSession;
import com.vexsoftware.votifier.net.protocol.v1crypto.RSAIO;
import com.vexsoftware.votifier.net.protocol.v1crypto.RSAKeygen;
import com.vexsoftware.votifier.platform.JavaUtilLogger;
import com.vexsoftware.votifier.platform.LoggingAdapter;
import com.vexsoftware.votifier.platform.VotifierPlugin;
import com.vexsoftware.votifier.platform.scheduler.VotifierScheduler;
import com.vexsoftware.votifier.support.forwarding.ForwardedVoteListener;
import com.vexsoftware.votifier.support.forwarding.ForwardingVoteSink;
import com.vexsoftware.votifier.util.IOUtil;
import com.vexsoftware.votifier.util.KeyCreator;
import com.vexsoftware.votifier.util.TokenUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.Key;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class NuVotifierBukkit
extends JavaPlugin
implements VoteHandler,
VotifierPlugin,
ForwardedVoteListener {
    private VotifierServerBootstrap bootstrap;
    private KeyPair keyPair;
    private boolean debug;
    private Map<String, Key> tokens = new HashMap<String, Key>();
    private ForwardingVoteSink forwardingMethod;
    private VotifierScheduler scheduler;
    private LoggingAdapter pluginLogger;

    private boolean loadAndBind() {
        this.scheduler = new BukkitScheduler(this);
        this.pluginLogger = new JavaUtilLogger(this.getLogger());
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdir()) {
            throw new RuntimeException("Unable to create the plugin data folder " + this.getDataFolder());
        }
        File config = new File(this.getDataFolder(), "config.yml");
        String hostAddr = Bukkit.getServer().getIp();
        if (hostAddr == null || hostAddr.length() == 0) {
            hostAddr = "0.0.0.0";
        }
        if (!config.exists()) {
            try {
                this.getLogger().info("Configuring Votifier for the first time...");
                if (!config.createNewFile()) {
                    throw new IOException("Unable to create the config file at " + config);
                }
                String cfgStr = new String(IOUtil.readAllBytes(this.getResource("bukkitConfig.yml")), StandardCharsets.UTF_8);
                String token = TokenUtil.newToken();
                cfgStr = cfgStr.replace("%default_token%", token).replace("%ip%", hostAddr);
                Files.copy(new ByteArrayInputStream(cfgStr.getBytes(StandardCharsets.UTF_8)), config.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.getLogger().info("------------------------------------------------------------------------------");
                this.getLogger().info("Assigning NuVotifier to listen on port 8192. If you are hosting Craftbukkit on a");
                this.getLogger().info("shared server please check with your hosting provider to verify that this port");
                this.getLogger().info("is available for your use. Chances are that your hosting provider will assign");
                this.getLogger().info("a different port, which you need to specify in config.yml");
                this.getLogger().info("------------------------------------------------------------------------------");
                this.getLogger().info("Your default NuVotifier token is " + token + ".");
                this.getLogger().info("You will need to provide this token when you submit your server to a voting");
                this.getLogger().info("list.");
                this.getLogger().info("------------------------------------------------------------------------------");
            }
            catch (Exception ex) {
                this.getLogger().log(Level.SEVERE, "Error creating configuration file", ex);
                return false;
            }
        }
        File rsaDirectory = new File(this.getDataFolder(), "rsa");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)config);
        try {
            if (!rsaDirectory.exists()) {
                if (!rsaDirectory.mkdir()) {
                    throw new RuntimeException("Unable to create the RSA key folder " + rsaDirectory);
                }
                this.keyPair = RSAKeygen.generate(2048);
                RSAIO.save(rsaDirectory, this.keyPair);
            } else {
                this.keyPair = RSAIO.load(rsaDirectory);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "Error reading configuration file or RSA tokens", ex);
            return false;
        }
        this.debug = cfg.isBoolean("quiet") ? !cfg.getBoolean("quiet") : cfg.getBoolean("debug", true);
        ConfigurationSection tokenSection = cfg.getConfigurationSection("tokens");
        if (tokenSection != null) {
            Map websites = tokenSection.getValues(false);
            for (Map.Entry website : websites.entrySet()) {
                this.tokens.put((String)website.getKey(), KeyCreator.createKeyFrom(website.getValue().toString()));
                this.getLogger().info("Loaded token for website: " + (String)website.getKey());
            }
        } else {
            String token = TokenUtil.newToken();
            tokenSection = cfg.createSection("tokens");
            tokenSection.set("default", (Object)token);
            this.tokens.put("default", KeyCreator.createKeyFrom(token));
            try {
                cfg.save(config);
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Error generating Votifier token", e);
                return false;
            }
            this.getLogger().info("------------------------------------------------------------------------------");
            this.getLogger().info("No tokens were found in your configuration, so we've generated one for you.");
            this.getLogger().info("Your default Votifier token is " + token + ".");
            this.getLogger().info("You will need to provide this token when you submit your server to a voting");
            this.getLogger().info("list.");
            this.getLogger().info("------------------------------------------------------------------------------");
        }
        String host = cfg.getString("host", hostAddr);
        int port = cfg.getInt("port", 8192);
        if (!this.debug) {
            this.getLogger().info("QUIET mode enabled!");
        }
        if (port >= 0) {
            boolean disablev1 = cfg.getBoolean("disable-v1-protocol");
            if (disablev1) {
                this.getLogger().info("------------------------------------------------------------------------------");
                this.getLogger().info("Votifier protocol v1 parsing has been disabled. Most voting websites do not");
                this.getLogger().info("currently support the modern Votifier protocol in NuVotifier.");
                this.getLogger().info("------------------------------------------------------------------------------");
            }
            this.bootstrap = new VotifierServerBootstrap(host, port, this, disablev1);
            this.bootstrap.start(error -> {});
        } else {
            this.getLogger().info("------------------------------------------------------------------------------");
            this.getLogger().info("Your Votifier port is less than 0, so we assume you do NOT want to start the");
            this.getLogger().info("votifier port server! Votifier will not listen for votes over any port, and");
            this.getLogger().info("will only listen for pluginMessaging forwarded votes!");
            this.getLogger().info("------------------------------------------------------------------------------");
        }
        ConfigurationSection forwardingConfig = cfg.getConfigurationSection("forwarding");
        if (forwardingConfig != null) {
            String method = forwardingConfig.getString("method", "none").toLowerCase();
            if ("none".equals(method)) {
                this.getLogger().info("Method none selected for vote forwarding: Votes will not be received from a forwarder.");
            } else if ("pluginmessaging".equals(method)) {
                String channel = forwardingConfig.getString("pluginMessaging.channel", "NuVotifier");
                try {
                    this.forwardingMethod = new BukkitPluginMessagingForwardingSink((Plugin)this, channel, this);
                    this.getLogger().info("Receiving votes over PluginMessaging channel '" + channel + "'.");
                }
                catch (RuntimeException e) {
                    this.getLogger().log(Level.SEVERE, "NuVotifier could not set up PluginMessaging for vote forwarding!", e);
                }
            } else {
                this.getLogger().severe("No vote forwarding method '" + method + "' known. Defaulting to noop implementation.");
            }
        }
        return true;
    }

    private void halt() {
        if (this.bootstrap != null) {
            this.bootstrap.shutdown();
            this.bootstrap = null;
        }
        if (this.forwardingMethod != null) {
            this.forwardingMethod.halt();
            this.forwardingMethod = null;
        }
    }

    public void onEnable() {
        this.getCommand("nvreload").setExecutor((CommandExecutor)new NVReloadCmd(this));
        this.getCommand("testvote").setExecutor((CommandExecutor)new TestVoteCmd(this));
        if (!this.loadAndBind()) {
            this.gracefulExit();
            this.setEnabled(false);
        }
    }

    public void onDisable() {
        this.halt();
        this.getLogger().info("Votifier disabled.");
    }

    public boolean reload() {
        try {
            this.halt();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "On halt, an exception was thrown. This may be fine!", ex);
        }
        if (this.loadAndBind()) {
            this.getLogger().info("Reload was successful.");
            return true;
        }
        try {
            this.halt();
            this.getLogger().log(Level.SEVERE, "On reload, there was a problem with the configuration. Votifier currently does nothing!");
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "On reload, there was a problem loading, and we could not re-halt the server. Votifier is in an unstable state!", ex);
        }
        return false;
    }

    private void gracefulExit() {
        this.getLogger().log(Level.SEVERE, "Votifier did not initialize properly!");
    }

    @Override
    public LoggingAdapter getPluginLogger() {
        return this.pluginLogger;
    }

    @Override
    public VotifierScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public Map<String, Key> getTokens() {
        return this.tokens;
    }

    @Override
    public KeyPair getProtocolV1Key() {
        return this.keyPair;
    }

    @Override
    public void onVoteReceived(Vote vote, VotifierSession.ProtocolVersion protocolVersion, String remoteAddress) {
        if (this.debug) {
            this.getLogger().info("Got a " + protocolVersion.humanReadable + " vote record from " + remoteAddress + " -> " + vote);
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> this.fireVotifierEvent(vote));
    }

    @Override
    public void onError(Throwable throwable, boolean alreadyHandledVote, String remoteAddress) {
        if (this.debug) {
            if (alreadyHandledVote) {
                this.getLogger().log(Level.SEVERE, "Vote processed, however an exception occurred with a vote from " + remoteAddress, throwable);
            } else {
                this.getLogger().log(Level.SEVERE, "Unable to process vote from " + remoteAddress, throwable);
            }
        } else if (!alreadyHandledVote) {
            this.getLogger().log(Level.SEVERE, "Unable to process vote from " + remoteAddress);
        }
    }

    @Override
    public void onForward(Vote v) {
        if (this.debug) {
            this.getLogger().info("Got a forwarded vote -> " + v);
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> this.fireVotifierEvent(v));
    }

    private void fireVotifierEvent(Vote vote) {
        if (VotifierEvent.getHandlerList().getRegisteredListeners().length == 0) {
            this.getLogger().log(Level.SEVERE, "A vote was received, but you don't have any listeners available to listen for it.");
            this.getLogger().log(Level.SEVERE, "See https://github.com/NuVotifier/NuVotifier/wiki/Setup-Guide#vote-listeners for");
            this.getLogger().log(Level.SEVERE, "a list of listeners you can configure.");
        }
        Bukkit.getPluginManager().callEvent((Event)new VotifierEvent(vote));
    }
}

