/*
 * Decompiled with CFR 0.152.
 */
package com.vexsoftware.votifier;

import com.vexsoftware.votifier.NuVotifierBukkit;
import com.vexsoftware.votifier.platform.scheduler.ScheduledVotifierTask;
import com.vexsoftware.votifier.platform.scheduler.VotifierScheduler;
import java.util.concurrent.TimeUnit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

class BukkitScheduler
implements VotifierScheduler {
    private final NuVotifierBukkit plugin;

    public BukkitScheduler(NuVotifierBukkit plugin) {
        this.plugin = plugin;
    }

    private int toTicks(int time, TimeUnit unit) {
        return (int)(unit.toMillis(time) / 50L);
    }

    @Override
    public ScheduledVotifierTask sync(Runnable runnable) {
        return new BukkitTaskWrapper(this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, runnable));
    }

    @Override
    public ScheduledVotifierTask onPool(Runnable runnable) {
        return new BukkitTaskWrapper(this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, runnable));
    }

    @Override
    public ScheduledVotifierTask delayedSync(Runnable runnable, int delay, TimeUnit unit) {
        return new BukkitTaskWrapper(this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, runnable, (long)this.toTicks(delay, unit)));
    }

    @Override
    public ScheduledVotifierTask delayedOnPool(Runnable runnable, int delay, TimeUnit unit) {
        return new BukkitTaskWrapper(this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, runnable, (long)this.toTicks(delay, unit)));
    }

    @Override
    public ScheduledVotifierTask repeatOnPool(Runnable runnable, int delay, int repeat, TimeUnit unit) {
        return new BukkitTaskWrapper(this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, runnable, (long)this.toTicks(delay, unit), (long)this.toTicks(repeat, unit)));
    }

    private static class BukkitTaskWrapper
    implements ScheduledVotifierTask {
        private final BukkitTask task;

        private BukkitTaskWrapper(BukkitTask task) {
            this.task = task;
        }

        @Override
        public void cancel() {
            this.task.cancel();
        }
    }
}

