/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.utils;

import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.utils.ActionbarUtil;
import com.live.bemmamin.gps.utils.CustomJSONParser;
import com.live.bemmamin.gps.utils.TitleBarUtil;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public final class StringUtil {
    private static final Pattern TITLE_MESSAGE_PATTERN = Pattern.compile("^<title,\\d+,\\d+,\\d+>.*");

    public static String translate(String string) {
        String string2 = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        Matcher matcher = Pattern.compile("&#([A-Fa-f0-9]{6})").matcher(string2);
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 32);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = "\u00a7x" + string3.chars().mapToObj(n -> '\u00a7' + String.valueOf((char)n)).collect(Collectors.joining());
            matcher.appendReplacement(stringBuffer, string4);
        }
        return matcher.appendTail(stringBuffer).toString();
    }

    public static void msgSend(Player player, String string) {
        string = string.replace("%prefix%", MessagesFile.getInstance().getPrefix()).replace("%confPrefix%", MessagesFile.getInstance().getConfiguratorPrefix()).replace("%adminPrefix%", MessagesFile.getInstance().getAdminPrefix());
        string = StringUtil.translate(string);
        boolean bl = string.toLowerCase().startsWith("<actionbar>");
        boolean bl2 = TITLE_MESSAGE_PATTERN.matcher(string.toLowerCase()).matches();
        if (bl) {
            string = string.substring(11);
        }
        if (player != null && bl) {
            ActionbarUtil.sendMessage(player, string, false);
        } else if (player != null && bl2) {
            TitleBarUtil.sendTitleBar(player, string);
        } else if (!string.isEmpty()) {
            if (!string.contains("[\"") && !string.contains("\"]")) {
                if (player != null) {
                    player.sendMessage(string);
                } else {
                    Bukkit.getServer().getConsoleSender().sendMessage(string);
                }
            } else {
                BaseComponent baseComponent = CustomJSONParser.parseMessage(string);
                if (player != null) {
                    player.spigot().sendMessage(baseComponent);
                } else {
                    Bukkit.getServer().getConsoleSender().sendMessage(baseComponent.toLegacyText());
                }
            }
        }
    }

    public static String formatDouble(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(Vars.getInstance().isGermanLocale() ? Locale.GERMAN : Locale.US));
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat.format(d);
    }

    public static void debug(Object ... objectArray) {
        Bukkit.getServer().getLogger().info(Arrays.toString(objectArray));
    }

    public static String locationToString(Location location) {
        return location.getWorld().getName() + ", " + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ();
    }
}

