/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.utils;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.playerdata.ConfiguratorData;
import com.live.bemmamin.gps.playerdata.PlayerData;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ParticleUtil {
    private static final float[] RAINBOW_COLOR_STATE = new float[]{255.0f, 0.0f, 0.0f};
    private static Constructor<?> one13Constructor;
    private final Player player;
    private final List<String> drawn = new ArrayList<String>();
    private List<Point> points;
    private ConfiguratorData configuratorData = null;
    private PlayerData playerData = null;

    public ParticleUtil(Player player) {
        this.player = player;
        this.configuratorData = ConfiguratorData.getConfiguratorData(player);
    }

    public ParticleUtil(Player player, List<Point> list) {
        this.player = player;
        this.points = list;
        this.playerData = PlayerData.getPlayerData(player);
    }

    public static void startRainbowTask(Main main) {
        Bukkit.getScheduler().runTaskTimer((Plugin)main, () -> {
            if (RAINBOW_COLOR_STATE[0] == 255.0f && RAINBOW_COLOR_STATE[1] == 0.0f && RAINBOW_COLOR_STATE[2] != 255.0f) {
                RAINBOW_COLOR_STATE[2] = RAINBOW_COLOR_STATE[2] + 7.0f;
            } else if (RAINBOW_COLOR_STATE[0] != 0.0f && RAINBOW_COLOR_STATE[1] == 0.0f && RAINBOW_COLOR_STATE[2] == 255.0f) {
                RAINBOW_COLOR_STATE[0] = RAINBOW_COLOR_STATE[0] - 7.0f;
            } else if (RAINBOW_COLOR_STATE[0] == 0.0f && RAINBOW_COLOR_STATE[1] != 255.0f && RAINBOW_COLOR_STATE[2] == 255.0f) {
                RAINBOW_COLOR_STATE[1] = RAINBOW_COLOR_STATE[1] + 7.0f;
            } else if (RAINBOW_COLOR_STATE[0] == 0.0f && RAINBOW_COLOR_STATE[1] == 255.0f && RAINBOW_COLOR_STATE[2] != 0.0f) {
                RAINBOW_COLOR_STATE[2] = RAINBOW_COLOR_STATE[2] - 7.0f;
            } else if (RAINBOW_COLOR_STATE[0] != 255.0f && RAINBOW_COLOR_STATE[1] == 255.0f && RAINBOW_COLOR_STATE[2] == 0.0f) {
                RAINBOW_COLOR_STATE[0] = RAINBOW_COLOR_STATE[0] + 7.0f;
            } else if (RAINBOW_COLOR_STATE[0] == 255.0f && RAINBOW_COLOR_STATE[1] != 0.0f && RAINBOW_COLOR_STATE[2] == 0.0f) {
                RAINBOW_COLOR_STATE[1] = RAINBOW_COLOR_STATE[1] - 7.0f;
            }
            for (int i = 0; i < 3; ++i) {
                ParticleUtil.RAINBOW_COLOR_STATE[i] = RAINBOW_COLOR_STATE[i] > 255.0f ? 255.0f : (RAINBOW_COLOR_STATE[i] < 0.0f ? 0.0f : RAINBOW_COLOR_STATE[i]);
            }
        }, 0L, 1L);
    }

    public static Float[] parseColor(String string) {
        if (string.equalsIgnoreCase("rainbow")) {
            return null;
        }
        String[] stringArray = string.replace(" ", "").split(",");
        if (stringArray.length != 3) {
            stringArray = new String[]{"0", "0", "0"};
        }
        return new Float[]{Float.valueOf(Float.parseFloat(stringArray[0]) / 255.0f), Float.valueOf(Float.parseFloat(stringArray[1]) / 255.0f), Float.valueOf(Float.parseFloat(stringArray[2]) / 255.0f)};
    }

    public void highlightPointsAndConnections() {
        for (Point point : GPSManager.getInstance().getGlobalPoints()) {
            if (point.getLocation().getWorld() != this.player.getLocation().getWorld()) continue;
            Float[] floatArray = point.equals(this.configuratorData.getSelectedPoint()) ? Vars.getInstance().getSelectedPointColor() : (point.equals(this.configuratorData.getClosestPoint()) ? Vars.getInstance().getClosestPointColor() : Vars.getInstance().getDefaultPointColor());
            for (Location location : this.getCorners(point.getLocation().clone())) {
                this.spawnParticle(location, floatArray, false);
            }
            for (Point point2 : point.getConnections()) {
                String string = point.getSection() + point2.getSection();
                String string2 = point2.getSection() + point.getSection();
                if (this.drawn.contains(string) || this.drawn.contains(string2)) continue;
                this.drawn.addAll(Arrays.asList(string, string2));
                this.drawLineConnection(point, point2);
            }
        }
    }

    private void drawLineConnection(Point point, Point point2) {
        if (point.getLocation().getWorld() != point2.getLocation().getWorld()) {
            this.player.playEffect(point.getLocation(), Effect.ENDER_SIGNAL, null);
            return;
        }
        Location location = point.getLocation().clone();
        Location location2 = point2.getLocation().clone();
        Vector vector = this.alterLocation(location, location2);
        double d = location.distance(location2.subtract(vector)) - Vars.getInstance().getParticleDensity() / 2.0;
        for (double d2 = 0.0; d2 < d; d2 += Vars.getInstance().getParticleDensity()) {
            Location location3 = location.add(vector);
            if (point2.getConnections().contains(point) && d2 < Vars.getInstance().getParticleDensity() * 2.0 || point.getConnections().contains(point2) && d2 >= d - Vars.getInstance().getParticleDensity() * 2.0) {
                this.spawnParticle(location3, Vars.getInstance().getConnectedColor(), false);
                continue;
            }
            this.spawnParticle(location3, Vars.getInstance().getLineColor(), false);
        }
    }

    public void highlightPath() {
        Location location = this.player.getLocation().clone().add(0.0, Vars.getInstance().getPlayerPathOffset(), 0.0);
        if (this.playerData.getPath().getCurrentTarget() == null) {
            return;
        }
        this.drawLinePath(location, this.playerData.getPath().getCurrentTarget().getLocation().clone());
        try {
            if (!this.player.getWorld().equals(this.playerData.getPath().getCurrentTarget().getLocation().getWorld())) {
                this.drawLinePath(location, this.playerData.getTargetLocation());
            }
            for (int i = this.points.indexOf(this.playerData.getPath().getCurrentTarget()); i < this.points.size(); ++i) {
                location = this.points.get(i).getLocation();
                if (i != this.points.size() - 1) {
                    Location location2 = this.points.get(i + 1).getLocation();
                    this.drawLinePath(location.clone(), location2.clone());
                    continue;
                }
                break;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void drawLinePath(Location location, Location location2) {
        boolean bl;
        if (!location.getWorld().equals(this.player.getWorld()) || !location.getWorld().equals(location2.getWorld())) {
            this.player.playEffect(location, Effect.ENDER_SIGNAL, null);
            return;
        }
        boolean bl2 = this.player.getLocation().distance(location) < Vars.getInstance().getParticleRenderDistance();
        boolean bl3 = bl = this.player.getLocation().distance(location2) < Vars.getInstance().getParticleRenderDistance();
        if (bl2) {
            Vector vector = this.alterLocation(location, location2);
            this.drawLine(location, vector, location.distance(location2.subtract(vector)));
        } else if (bl) {
            Vector vector = this.alterLocation(location2, location);
            this.drawLine(location2, vector, location.distance(location2.subtract(vector)));
        }
    }

    private void drawLine(Location location, Vector vector, double d) {
        location.subtract(vector);
        for (double d2 = 0.0; d2 < d; d2 += Vars.getInstance().getParticleDensity()) {
            Location location2 = location.add(vector);
            if (d2 % 10.0 == 0.0 && this.player.getLocation().distance(location2) > Vars.getInstance().getParticleRenderDistance()) {
                return;
            }
            this.spawnParticle(location2, Vars.getInstance().getLineColor(), false);
        }
    }

    private Vector alterLocation(Location location, Location location2) {
        location.setY(location.getY() + 0.5);
        location2.setY(location2.getY() + 0.5);
        Vector vector = location2.toVector();
        location.setDirection(vector.subtract(location.toVector()));
        return location.getDirection().multiply(Vars.getInstance().getParticleDensity());
    }

    private List<Location> getCorners(Location location) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        List<double[]> list = Arrays.asList({0.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {1.0, 1.0, 1.0}, {1.0, 0.0, 1.0}, {0.0, 1.0, 1.0}, {0.0, 0.0, 1.0}, {0.0, 1.0, 0.0});
        for (double[] dArray : list) {
            arrayList.add(new Location(location.getWorld(), (double)location.getBlockX() + dArray[0], (double)location.getBlockY() + dArray[1], (double)location.getBlockZ() + dArray[2]));
        }
        return arrayList;
    }

    public void spawnParticleBox(Location location) {
        for (Location location2 : this.getCorners(location.clone())) {
            this.spawnParticle(location2, Vars.getInstance().getDefaultPointColor(), false);
        }
    }

    public void spawnParticleCube(Location location) {
        if (!Vars.getInstance().isParticleArrow3D()) {
            this.spawnParticle(location, Vars.getInstance().getParticleArrowColor(), !Vars.getInstance().isShowForOwnerOnly());
            return;
        }
        for (Integer n : Arrays.asList(45, -45, 135, -135)) {
            for (Integer n2 : Arrays.asList(45, -45)) {
                Location location2 = location.clone();
                double d = (double)location2.getPitch() - (double)location2.getPitch() * 0.5;
                double d2 = n > 0 ? (double)location2.getPitch() * 0.45 : -((double)location2.getPitch() * 0.45);
                double d3 = (double)(location2.getYaw() + (float)n.intValue()) + (d < 0.0 ? -d2 : d2);
                location2.setPitch((float)d + (float)n2.intValue());
                location2.setYaw((float)d3);
                location2.add(location2.getDirection().multiply(0.3));
                this.spawnParticle(location2, Vars.getInstance().getParticleArrowColor(), !Vars.getInstance().isShowForOwnerOnly());
            }
        }
    }

    public void spawnParticle(Location location, Float[] floatArray, boolean bl) {
        float[] fArray;
        if (floatArray == null) {
            float[] fArray2 = new float[3];
            fArray2[0] = RAINBOW_COLOR_STATE[0] / 255.0f;
            fArray2[1] = RAINBOW_COLOR_STATE[1] / 255.0f;
            fArray = fArray2;
            fArray2[2] = RAINBOW_COLOR_STATE[2] / 255.0f;
        } else {
            float[] fArray3 = new float[3];
            fArray3[0] = floatArray[0].floatValue();
            fArray3[1] = floatArray[1].floatValue();
            fArray = fArray3;
            fArray3[2] = floatArray[2].floatValue();
        }
        float[] fArray4 = fArray;
        if (Stream.of("1.8", "1.9", "1.10", "1.11", "1.12").noneMatch(Bukkit.getVersion()::contains)) {
            try {
                Object obj = one13Constructor.newInstance(Color.fromRGB((int)((int)(fArray4[0] * 255.0f)), (int)((int)(fArray4[1] * 255.0f)), (int)((int)(fArray4[2] * 255.0f))), 1);
                if (bl) {
                    location.getWorld().getPlayers().stream().filter(player -> player.getLocation().distance(location) < Vars.getInstance().getParticleRenderDistance()).forEach(player -> player.spawnParticle(Particle.REDSTONE, location, 1, obj));
                } else if (this.player.getLocation().distance(location) < Vars.getInstance().getParticleRenderDistance()) {
                    this.player.spawnParticle(Particle.REDSTONE, location, 1, obj);
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        } else if (bl) {
            location.getWorld().getPlayers().forEach(player -> player.spigot().playEffect(location, Effect.COLOURED_DUST, 0, 0, fArray4[0], fArray4[1], fArray4[2], 1.0f, 0, (int)Vars.getInstance().getParticleRenderDistance()));
        } else {
            this.player.spigot().playEffect(location, Effect.COLOURED_DUST, 0, 0, fArray4[0], fArray4[1], fArray4[2], 1.0f, 0, (int)Vars.getInstance().getParticleRenderDistance());
        }
    }

    public static float[] getRAINBOW_COLOR_STATE() {
        return RAINBOW_COLOR_STATE;
    }

    static {
        try {
            if (!Bukkit.getVersion().contains("1.8")) {
                one13Constructor = Particle.REDSTONE.getDataType().getConstructor(Color.class, Float.TYPE);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

