/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.utils;

import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.arrow.ArrowCreator;
import com.live.bemmamin.gps.arrow.ResourcePackArrow;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.playerdata.ConfiguratorData;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.TagUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class GPSUtil {
    public static Point closestPoint(Player player) {
        Point point2;
        HashMap<Double, Point> hashMap = new HashMap<Double, Point>();
        for (Point point2 : GPSManager.getInstance().getGlobalPoints()) {
            double d;
            if (point2.getLocation().getWorld() != player.getLocation().getWorld() || (d = point2.getLocation().distance(player.getLocation())) > Vars.getInstance().getSelectionMaxDistance()) continue;
            hashMap.put(d, point2);
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList);
        point2 = ConfiguratorData.getConfiguratorData(player).getSelectedPoint();
        if (hashMap.size() == 1 && ((Point)hashMap.get(arrayList.get(0))).equals(point2)) {
            return null;
        }
        return ((Point)hashMap.get(arrayList.get(0))).equals(point2) ? (Point)hashMap.get(arrayList.get(1)) : (Point)hashMap.get(arrayList.get(0));
    }

    public static void update(Player player) {
        PlayerData playerData;
        if (ConfiguratorData.contains(player)) {
            ConfiguratorData.getConfiguratorData(player).setClosestPoint(GPSUtil.closestPoint(player));
        }
        if (!(playerData = PlayerData.getPlayerData(player)).isGpsActive()) {
            return;
        }
        if (!(playerData.getArrow() instanceof ResourcePackArrow)) {
            playerData.getArrow().updateArrow(ArrowCreator.computeLocations(player, playerData.getTargetLocation()));
        } else {
            playerData.getArrow().updateArrow(ArrowCreator.resourcePackArrowLocation(player, playerData.getTargetLocation()));
        }
        playerData.getBossBarTracker().update();
    }

    public static String yawToCardinalDirection(float f) {
        if (0.0f <= f && (double)f < 22.5) {
            return "N";
        }
        if (22.5 <= (double)f && (double)f < 67.5) {
            return "NE";
        }
        if (67.5 <= (double)f && (double)f < 112.5) {
            return "E";
        }
        if (112.5 <= (double)f && (double)f < 157.5) {
            return "SE";
        }
        if (157.5 <= (double)f && (double)f < 202.5) {
            return "S";
        }
        if (202.5 <= (double)f && (double)f < 247.5) {
            return "SW";
        }
        if (247.5 <= (double)f && (double)f < 292.5) {
            return "W";
        }
        if (292.5 <= (double)f && (double)f < 337.5) {
            return "NW";
        }
        if (337.5 <= (double)f && (double)f < 360.0) {
            return "N";
        }
        return "None";
    }

    public static void cleanUp() {
        List list = PlayerData.getPlayerData().values().stream().flatMap(playerData -> playerData.getStands().stream()).collect(Collectors.toList());
        Bukkit.getWorlds().stream().flatMap(world -> world.getEntities().stream()).filter(entity -> entity instanceof ArmorStand && TagUtil.isTagged(entity) && !list.contains(entity)).forEach(Entity::remove);
    }
}

