/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.utils;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class EntityHider
implements Listener {
    private static final PacketType[] ENTITY_PACKETS = new PacketType[]{PacketType.Play.Server.ENTITY_EQUIPMENT, PacketType.Play.Server.ANIMATION, PacketType.Play.Server.NAMED_ENTITY_SPAWN, PacketType.Play.Server.COLLECT, PacketType.Play.Server.SPAWN_ENTITY, PacketType.Play.Server.SPAWN_ENTITY_LIVING, PacketType.Play.Server.SPAWN_ENTITY_PAINTING, PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB, PacketType.Play.Server.ENTITY_VELOCITY, PacketType.Play.Server.REL_ENTITY_MOVE, PacketType.Play.Server.ENTITY_LOOK, PacketType.Play.Server.ENTITY_MOVE_LOOK, PacketType.Play.Server.ENTITY_MOVE_LOOK, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.ENTITY_HEAD_ROTATION, PacketType.Play.Server.ENTITY_STATUS, PacketType.Play.Server.ATTACH_ENTITY, PacketType.Play.Server.ENTITY_METADATA, PacketType.Play.Server.ENTITY_EFFECT, PacketType.Play.Server.REMOVE_ENTITY_EFFECT, PacketType.Play.Server.BLOCK_BREAK_ANIMATION, PacketType.Play.Server.COMBAT_EVENT};
    private final Table<Integer, Integer, Boolean> observerEntityMap = HashBasedTable.create();
    private final ProtocolManager manager;
    private final Policy policy;

    public EntityHider(Plugin plugin, Policy policy) {
        Preconditions.checkNotNull((Object)plugin, (Object)"main cannot be NULL.");
        this.policy = policy;
        this.manager = ProtocolLibrary.getProtocolManager();
        plugin.getServer().getPluginManager().registerEvents(this.constructBukkit(), plugin);
        this.manager.addPacketListener((PacketListener)this.constructProtocol(plugin));
    }

    private boolean setVisibility(Player player, int n, boolean bl) {
        switch (this.policy) {
            case BLACKLIST: {
                return !this.setMembership(player, n, !bl);
            }
            case WHITELIST: {
                return this.setMembership(player, n, bl);
            }
        }
        throw new IllegalArgumentException("Unknown policy: " + (Object)((Object)this.policy));
    }

    private boolean setMembership(Player player, int n, boolean bl) {
        if (bl) {
            return this.observerEntityMap.put((Object)player.getEntityId(), (Object)n, (Object)true) != null;
        }
        return this.observerEntityMap.remove((Object)player.getEntityId(), (Object)n) != null;
    }

    private boolean getMembership(Player player, int n) {
        try {
            return this.observerEntityMap.contains((Object)player.getEntityId(), (Object)n);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isVisible(Player player, int n) {
        boolean bl = this.getMembership(player, n);
        return this.policy == Policy.WHITELIST == bl;
    }

    private void removeEntity(Entity entity) {
        int n = entity.getEntityId();
        for (Map map : this.observerEntityMap.rowMap().values()) {
            map.remove(n);
        }
    }

    private void removePlayer(Player player) {
        this.observerEntityMap.rowMap().remove(player.getEntityId());
    }

    private Listener constructBukkit() {
        return new Listener(){

            @EventHandler
            public void onEntityDeath(EntityDeathEvent entityDeathEvent) {
                EntityHider.this.removeEntity((Entity)entityDeathEvent.getEntity());
            }

            @EventHandler
            public void onChunkUnload(ChunkUnloadEvent chunkUnloadEvent) {
                for (Entity entity : chunkUnloadEvent.getChunk().getEntities()) {
                    EntityHider.this.removeEntity(entity);
                }
            }

            @EventHandler
            public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
                EntityHider.this.removePlayer(playerQuitEvent.getPlayer());
            }
        };
    }

    private PacketAdapter constructProtocol(Plugin plugin) {
        PacketType[] packetTypeArray;
        try {
            Set set = PacketRegistry.getServerPacketTypes();
            Set set2 = PacketRegistry.getClientPacketTypes();
            packetTypeArray = (PacketType[])Stream.of(ENTITY_PACKETS).filter(packetType -> {
                Set set3 = packetType.getSender() == PacketType.Sender.CLIENT ? set2 : set;
                return set3.contains(packetType);
            }).toArray(PacketType[]::new);
        }
        catch (Exception exception) {
            packetTypeArray = ENTITY_PACKETS;
        }
        return new PacketAdapter(plugin, packetTypeArray){

            public void onPacketSending(PacketEvent packetEvent) {
                int n = packetEvent.getPacketType() == PacketType.Play.Server.COMBAT_EVENT ? 1 : 0;
                Integer n2 = (Integer)packetEvent.getPacket().getIntegers().readSafely(n);
                if (n2 != null && !EntityHider.this.isVisible(packetEvent.getPlayer(), n2)) {
                    packetEvent.setCancelled(true);
                }
            }
        };
    }

    public final void showEntity(Player player, Entity entity) {
        boolean bl;
        this.validate(player, entity);
        boolean bl2 = bl = !this.setVisibility(player, entity.getEntityId(), true);
        if (this.manager != null && bl) {
            this.manager.updateEntity(entity, Collections.singletonList(player));
        }
    }

    public final void hideEntity(Player player, Entity entity) {
        this.validate(player, entity);
        boolean bl = this.setVisibility(player, entity.getEntityId(), false);
        if (bl) {
            PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
            if (Stream.of("1.8", "1.9", "1.10", "1.11", "1.12", "1.13", "1.14", "1.15", "1.16").anyMatch(Bukkit.getVersion()::contains)) {
                packetContainer.getIntegerArrays().write(0, (Object)new int[]{entity.getEntityId()});
            } else {
                packetContainer.getIntLists().write(0, Collections.singletonList(entity.getEntityId()));
            }
            try {
                this.manager.sendServerPacket(player, packetContainer);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Cannot send server packet.", invocationTargetException);
            }
        }
    }

    private void validate(Player player, Entity entity) {
        Preconditions.checkNotNull((Object)player, (Object)"observer cannot be NULL.");
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be NULL.");
    }

    public static enum Policy {
        WHITELIST,
        BLACKLIST;

    }
}

