/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.playerdata;

import com.live.bemmamin.gps.Enums;
import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.arrow.AbstractArrow;
import com.live.bemmamin.gps.arrow.ArrowCreator;
import com.live.bemmamin.gps.arrow.EntityArrow;
import com.live.bemmamin.gps.arrow.ParticleArrow;
import com.live.bemmamin.gps.arrow.ResourcePackArrow;
import com.live.bemmamin.gps.files.CrashSafetyFile;
import com.live.bemmamin.gps.logic.BossBarTracker;
import com.live.bemmamin.gps.logic.CompassItem;
import com.live.bemmamin.gps.logic.Path;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.utils.ActionbarUtil;
import com.live.bemmamin.gps.utils.GPSUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public final class PlayerData {
    private static final HashMap<UUID, PlayerData> playerData = new HashMap();
    private final UUID uuid;
    private final BossBarTracker bossBarTracker;
    private boolean gpsActive = false;
    private boolean arrowChangePositionMode = false;
    private List<ArmorStand> stands = new ArrayList<ArmorStand>();
    private AbstractArrow abstractArrow = null;
    private double arrowHorizontalDistanceFromPlayer = Vars.getInstance().getDefaultHorizontalOffset();
    private double arrowVerticalOffsetFromPlayer = Vars.getInstance().getDefaultVerticalOffset();
    private Location targetLocation;
    private Path path = null;
    private BukkitTask visualPathTask = null;
    private boolean scheduledArrowDeathRespawn;
    private boolean compassMode = false;
    private double movementSpeed = 0.0;
    private long quitTime;
    private boolean idle;
    private BukkitTask gpsUpdateTask = null;
    private boolean toggledOff;

    private PlayerData(UUID uUID) {
        this.uuid = uUID;
        this.bossBarTracker = new BossBarTracker(this);
    }

    public static Map<UUID, PlayerData> getPlayerData() {
        return playerData;
    }

    public static PlayerData getPlayerData(Player player) {
        return playerData.computeIfAbsent(player.getUniqueId(), uUID -> new PlayerData(player.getUniqueId()));
    }

    public static boolean contains(Player player) {
        return playerData.containsKey(player.getUniqueId());
    }

    public static boolean contains(UUID uUID) {
        return playerData.containsKey(uUID);
    }

    public static PlayerData getPlayerData(UUID uUID) {
        return playerData.computeIfAbsent(uUID, uUID2 -> new PlayerData(uUID));
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public AbstractArrow getArrow() {
        return this.abstractArrow != null ? this.abstractArrow : (Vars.getInstance().isParticleArrow() ? new ParticleArrow(this) : (Vars.getInstance().isResourcePackArrow() ? new ResourcePackArrow(this) : new EntityArrow(this)));
    }

    public void changeArrowPosition(Enums.OffsetDirection offsetDirection) {
        switch (offsetDirection) {
            case AWAY: {
                this.arrowHorizontalDistanceFromPlayer = this.arrowHorizontalDistanceFromPlayer >= Vars.getInstance().getMaxHorizontalOffset() ? this.arrowHorizontalDistanceFromPlayer : this.arrowHorizontalDistanceFromPlayer + 1.0;
                break;
            }
            case TOWARDS: {
                this.arrowHorizontalDistanceFromPlayer = this.arrowHorizontalDistanceFromPlayer <= Vars.getInstance().getMinHorizontalOffset() ? this.arrowHorizontalDistanceFromPlayer : this.arrowHorizontalDistanceFromPlayer - 1.0;
                break;
            }
            case UP: {
                this.arrowVerticalOffsetFromPlayer = this.arrowVerticalOffsetFromPlayer >= Vars.getInstance().getMaxVerticalOffset() ? this.arrowVerticalOffsetFromPlayer : this.arrowVerticalOffsetFromPlayer + 0.5;
                break;
            }
            case DOWN: {
                this.arrowVerticalOffsetFromPlayer = this.arrowVerticalOffsetFromPlayer <= Vars.getInstance().getMinVerticalOffset() ? this.arrowVerticalOffsetFromPlayer : this.arrowVerticalOffsetFromPlayer - 0.5;
            }
        }
    }

    public void exitNavigation() {
        this.gpsActive = false;
        this.arrowChangePositionMode = false;
        this.stands.forEach(Entity::remove);
        CrashSafetyFile.getInstance().removeEntities(this.stands);
        this.stands = new ArrayList<ArmorStand>();
        this.abstractArrow = null;
        if (this.path != null) {
            this.path.cancel();
        }
        this.path = null;
        if (this.visualPathTask != null) {
            this.cancelVisualPointsTask();
        }
        if (this.gpsUpdateTask != null) {
            this.gpsUpdateTask.cancel();
            this.gpsUpdateTask = null;
        }
        this.compassMode = false;
        if (this.getPlayer() != null) {
            ActionbarUtil.sendMessage(this.getPlayer(), "", true);
            CompassItem.setCompassTarget(this.getPlayer(), this.getPlayer().getWorld().getSpawnLocation());
            CompassItem.removeCompass(this.getPlayer());
        }
        this.bossBarTracker.remove();
        ((Main)Main.getPlugin(Main.class)).getInactivityTimer().removePlayer(this.uuid);
    }

    public void startNavigation(Point point, boolean bl, String string) {
        this.exitNavigation();
        this.compassMode = bl;
        this.path = new Path(this, point, string);
    }

    public void startNavigation(Point point, Point point2, String string) {
        this.exitNavigation();
        this.path = new Path(this, point, point2, string);
    }

    public void cancelVisualPointsTask() {
        this.visualPathTask.cancel();
        this.visualPathTask = null;
    }

    public void gpsUpdateTask() {
        if (this.gpsUpdateTask != null) {
            return;
        }
        this.gpsUpdateTask = new BukkitRunnable(){
            private Location prev;
            private Location current;
            private int forceUpdate;
            {
                this.current = PlayerData.this.getPlayer().getLocation();
                this.forceUpdate = 0;
            }

            public void run() {
                if (PlayerData.this.getPlayer() == null || !PlayerData.this.getPlayer().isOnline()) {
                    if (PlayerData.this.quitTime + Vars.getInstance().getMaxQuitTime() < Instant.now().getEpochSecond()) {
                        PlayerData.this.exitNavigation();
                        this.cancel();
                    }
                    return;
                }
                ++this.forceUpdate;
                this.prev = this.current;
                this.current = PlayerData.this.getPlayer().getLocation();
                if (this.prev.equals((Object)this.current) && this.forceUpdate <= 12 && !Vars.getInstance().isParticleArrow()) {
                    return;
                }
                this.forceUpdate = 0;
                GPSUtil.update(PlayerData.this.getPlayer());
            }
        }.runTaskTimer((Plugin)Main.getPlugin(Main.class), 1L, 3L);
    }

    public void setTargetLocation(Location location) {
        if (location.equals((Object)this.targetLocation)) {
            return;
        }
        this.targetLocation = location;
        if (!this.gpsActive || Vars.getInstance().isDisableArrow()) {
            return;
        }
        if (!(this.getArrow() instanceof ResourcePackArrow)) {
            this.getArrow().updateArrow(ArrowCreator.computeLocations(this.getPlayer(), location));
        } else {
            this.getArrow().updateArrow(ArrowCreator.resourcePackArrowLocation(this.getPlayer(), location));
        }
    }

    public BossBarTracker getBossBarTracker() {
        return this.bossBarTracker;
    }

    public boolean isGpsActive() {
        return this.gpsActive;
    }

    public void setGpsActive(boolean bl) {
        this.gpsActive = bl;
    }

    public boolean isArrowChangePositionMode() {
        return this.arrowChangePositionMode;
    }

    public void setArrowChangePositionMode(boolean bl) {
        this.arrowChangePositionMode = bl;
    }

    public List<ArmorStand> getStands() {
        return this.stands;
    }

    public void setStands(List<ArmorStand> list) {
        this.stands = list;
    }

    public AbstractArrow getAbstractArrow() {
        return this.abstractArrow;
    }

    public void setAbstractArrow(AbstractArrow abstractArrow) {
        this.abstractArrow = abstractArrow;
    }

    public double getArrowHorizontalDistanceFromPlayer() {
        return this.arrowHorizontalDistanceFromPlayer;
    }

    public double getArrowVerticalOffsetFromPlayer() {
        return this.arrowVerticalOffsetFromPlayer;
    }

    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public BukkitTask getVisualPathTask() {
        return this.visualPathTask;
    }

    public void setVisualPathTask(BukkitTask bukkitTask) {
        this.visualPathTask = bukkitTask;
    }

    public boolean isScheduledArrowDeathRespawn() {
        return this.scheduledArrowDeathRespawn;
    }

    public void setScheduledArrowDeathRespawn(boolean bl) {
        this.scheduledArrowDeathRespawn = bl;
    }

    public boolean isCompassMode() {
        return this.compassMode;
    }

    public double getMovementSpeed() {
        return this.movementSpeed;
    }

    public void setMovementSpeed(double d) {
        this.movementSpeed = d;
    }

    public long getQuitTime() {
        return this.quitTime;
    }

    public void setQuitTime(long l) {
        this.quitTime = l;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public void setIdle(boolean bl) {
        this.idle = bl;
    }

    public boolean isToggledOff() {
        return this.toggledOff;
    }

    public void setToggledOff(boolean bl) {
        this.toggledOff = bl;
    }
}

