/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.playerdata;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.configurator.ConfiguratorStickManager;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.utils.ParticleUtil;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public final class ConfiguratorData {
    private static final HashMap<UUID, ConfiguratorData> configuratorData = new HashMap();
    private final UUID uuid;
    private boolean editorActivated = false;
    private Point selectedPoint = null;
    private Point closestPoint = null;
    private boolean autoConnect = false;
    private BukkitTask visualPointsTask = null;
    private Point stickTargetPoint;
    private Location stickTargetLocation;
    private BukkitTask stickTask;

    private ConfiguratorData(UUID uUID) {
        this.uuid = uUID;
    }

    public static ConfiguratorData getConfiguratorData(Player player) {
        return configuratorData.computeIfAbsent(player.getUniqueId(), uUID -> new ConfiguratorData(player.getUniqueId()));
    }

    public static boolean contains(Player player) {
        return configuratorData.containsKey(player.getUniqueId());
    }

    private Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public void cancelVisualPointsTask() {
        this.visualPointsTask.cancel();
        this.visualPointsTask = null;
    }

    public void startStickSelectionTask() {
        if (this.stickTask != null) {
            return;
        }
        ConfiguratorStickManager configuratorStickManager = new ConfiguratorStickManager();
        final Player player = this.getPlayer();
        this.stickTask = new BukkitRunnable(){

            public void run() {
                if (!(player.isOnline() && ConfiguratorData.this.isEditorActivated() && player.getItemInHand() != null && player.getItemInHand().hasItemMeta() && player.getItemInHand().getItemMeta().hasDisplayName() && player.getItemInHand().getItemMeta().getDisplayName().contains(ConfiguratorStickManager.getHiddenIdentifier()))) {
                    this.cancel();
                    ConfiguratorData.this.stickTask = null;
                    return;
                }
                List list = player.getLineOfSight(null, 100);
                for (Block block : list) {
                    Location location = new Location(block.getLocation().getWorld(), (double)block.getLocation().getBlockX(), (double)block.getLocation().getBlockY(), (double)block.getLocation().getBlockZ());
                    for (Point point : GPSManager.getInstance().getGlobalPoints()) {
                        Location location2 = new Location(point.getLocation().getWorld(), (double)point.getLocation().getBlockX(), (double)point.getLocation().getBlockY(), (double)point.getLocation().getBlockZ());
                        if (!location2.equals((Object)location)) continue;
                        ConfiguratorData.this.stickTargetPoint = point;
                        ConfiguratorData.this.stickTargetLocation = null;
                        new ParticleUtil(player).spawnParticle(location2, Vars.getInstance().getDefaultPointColor(), false);
                        return;
                    }
                }
                List list2 = player.getLastTwoTargetBlocks(null, 100);
                if (list2.size() == 2) {
                    Block block;
                    block = (Block)list2.get(0);
                    ConfiguratorData.this.stickTargetLocation = block.getLocation();
                    ConfiguratorData.this.stickTargetPoint = null;
                    new ParticleUtil(player).spawnParticleBox(block.getLocation());
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(Main.class), 0L, 5L);
    }

    public boolean isEditorActivated() {
        return this.editorActivated;
    }

    public Point getSelectedPoint() {
        return this.selectedPoint;
    }

    public Point getClosestPoint() {
        return this.closestPoint;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public Point getStickTargetPoint() {
        return this.stickTargetPoint;
    }

    public Location getStickTargetLocation() {
        return this.stickTargetLocation;
    }

    public void setEditorActivated(boolean bl) {
        this.editorActivated = bl;
    }

    public void setSelectedPoint(Point point) {
        this.selectedPoint = point;
    }

    public void setClosestPoint(Point point) {
        this.closestPoint = point;
    }

    public void setAutoConnect(boolean bl) {
        this.autoConnect = bl;
    }

    public void setVisualPointsTask(BukkitTask bukkitTask) {
        this.visualPointsTask = bukkitTask;
    }
}

