/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.logic;

import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.files.PointsFile;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class Point {
    private final String name;
    private final List<Point> connections = new ArrayList<Point>();
    private final List<String> flags = new ArrayList<String>();
    private final String section;
    private final double updateDistance;
    private Location location;
    private String customDestinationMessage;
    private String destinationSound;
    private String permission;
    private ConfigurationSection configurationSection;

    public Point(String string, Location location) {
        this.name = string;
        this.section = string + "section";
        this.location = location;
        this.updateDistance = Vars.getInstance().getPointUpdateDistance();
    }

    Point(ConfigurationSection configurationSection) {
        this.configurationSection = configurationSection;
        this.checkLegacy();
        this.section = configurationSection.getName();
        this.name = configurationSection.getString("name", this.section);
        this.setLocation();
        this.updateDistance = configurationSection.getDouble("updateDistance", Vars.getInstance().getPointUpdateDistance());
        this.customDestinationMessage = StringUtil.translate(configurationSection.getString("message", ""));
        this.permission = configurationSection.getString("permission");
        this.flags.addAll(configurationSection.getStringList("flags"));
        this.destinationSound = configurationSection.getString("sound");
    }

    private void checkLegacy() {
        if (this.configurationSection.contains("location")) {
            FileConfiguration fileConfiguration = PointsFile.getInstance().getConfig();
            fileConfiguration.set("Points." + this.configurationSection.getString("location") + ".name", (Object)this.configurationSection.getName());
            GPSManager.getInstance().getLegacyConnectionMap().putIfAbsent(this.configurationSection.getName(), this.configurationSection.getString("location"));
            if (this.configurationSection.contains("connections")) {
                fileConfiguration.set("Points." + this.configurationSection.getString("location") + ".connections", (Object)this.configurationSection.getStringList("connections"));
            }
            fileConfiguration.set("Points." + this.configurationSection.getName(), null);
            this.configurationSection = fileConfiguration.getConfigurationSection("Points." + this.configurationSection.getString("location"));
        }
    }

    private void setLocation() {
        double d;
        double d2;
        double d3;
        String[] stringArray = this.configurationSection.getName().split(",");
        if (stringArray.length != 4) {
            MessagesFile.getInstance().getInvalidPoint().replace("%point%", this.name).send();
            GPSManager.getInstance().getGlobalPoints().remove(this);
            return;
        }
        World world = Bukkit.getWorld((String)stringArray[0]);
        if (world == null) {
            MessagesFile.getInstance().getInvalidPoint().replace("%point%", this.name).send();
            GPSManager.getInstance().getGlobalPoints().remove(this);
            return;
        }
        try {
            d3 = Math.floor(Double.parseDouble(stringArray[1].replace(" ", ""))) + 0.5;
            d2 = Math.floor(Double.parseDouble(stringArray[2].replace(" ", ""))) + 0.1;
            d = Math.floor(Double.parseDouble(stringArray[3].replace(" ", ""))) + 0.5;
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            MessagesFile.getInstance().getInvalidPoint().replace("%point%", this.name).send();
            GPSManager.getInstance().getGlobalPoints().remove(this);
            return;
        }
        this.location = new Location(world, d3, d2, d);
    }

    void setConnections() {
        this.configurationSection.getStringList("connections").forEach(string -> GPSManager.getInstance().getLocalPoints().stream().filter(point -> point.getSection().equals(string) && !this.connections.contains(point)).forEach(this.connections::add));
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty() && !this.name.equals(this.section);
    }

    public boolean hasPermission() {
        return this.permission != null;
    }

    public void addConnection(Point point) {
        this.connections.add(point);
    }

    public void removeConnection(Point point) {
        this.connections.remove(point);
    }

    boolean hasCustomDestinationMessage() {
        return this.customDestinationMessage != null && !this.customDestinationMessage.isEmpty();
    }

    double distance(Point point) {
        return this.distance(point.location);
    }

    public double distance(Location location) {
        return this.location.getWorld().equals(location.getWorld()) ? this.location.distance(location) : Vars.getInstance().getTeleportConnectionDistance();
    }

    public void setPermission(String string) {
    }

    public String getName() {
        return this.name;
    }

    public List<Point> getConnections() {
        return this.connections;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public String getSection() {
        return this.section;
    }

    public double getUpdateDistance() {
        return this.updateDistance;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getCustomDestinationMessage() {
        return this.customDestinationMessage;
    }

    public String getDestinationSound() {
        return this.destinationSound;
    }

    public String getPermission() {
        return this.permission;
    }
}

