/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.logic;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.api.events.GPSStopEvent;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.logic.CompassItem;
import com.live.bemmamin.gps.logic.Computation;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.ParticleUtil;
import com.live.bemmamin.gps.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Path {
    private final PlayerData playerData;
    private final Point end;
    private final Point start;
    private final String startMessage;
    private final Map<String, List<Point>> pathCache = new HashMap<String, List<Point>>();
    private BukkitTask task;
    private List<Point> path;
    private Point currentTarget;

    public Path(PlayerData playerData, Point point, String string) {
        this.playerData = playerData;
        this.end = point;
        this.startMessage = string;
        Point point2 = this.start = playerData.isCompassMode() ? point : this.findClosestEntryPoint();
        if (this.start == null || playerData.isCompassMode() && !playerData.getPlayer().getWorld().equals(point.getLocation().getWorld())) {
            GPSStopEvent gPSStopEvent = new GPSStopEvent(playerData.getPlayer(), GPSStopEvent.StopSource.PLUGIN);
            Bukkit.getPluginManager().callEvent((Event)gPSStopEvent);
            playerData.exitNavigation();
            (this.start == null ? MessagesFile.getInstance().getNoEntry() : MessagesFile.getInstance().getCantReachDestination()).send(playerData.getPlayer());
            return;
        }
        this.path = new Computation(this.start, point).getShortestPath();
        this.pathCache.put(this.start.getSection(), this.path);
        playerData.gpsUpdateTask();
        this.startCheck();
    }

    public Path(PlayerData playerData, Point point, Point point2, String string) {
        this.playerData = playerData;
        this.startMessage = string;
        this.path = new Computation(point, point2).getShortestPath();
        this.end = point2;
        this.start = point;
        this.pathCache.put(point.getSection(), this.path);
        playerData.gpsUpdateTask();
        this.startCheck();
    }

    private void startCheck() {
        Player player = this.playerData.getPlayer();
        if (this.start.equals(this.end)) {
            this.path = new ArrayList<Point>(Collections.singletonList(this.end));
            if (!player.getLocation().getWorld().equals(this.end.getLocation().getWorld()) || player.getLocation().distance(this.end.getLocation()) < this.end.getUpdateDistance()) {
                GPSStopEvent gPSStopEvent = new GPSStopEvent(player, GPSStopEvent.StopSource.DESTINATION_REACHED);
                Bukkit.getPluginManager().callEvent((Event)gPSStopEvent);
                StringUtil.msgSend(player, gPSStopEvent.getCustomStopMessage() == null ? (this.end.hasCustomDestinationMessage() ? this.end.getCustomDestinationMessage() : MessagesFile.getInstance().getDestinationReached().toString()) : gPSStopEvent.getCustomStopMessage());
                this.playerData.exitNavigation();
                return;
            }
        }
        if (this.path == null) {
            GPSStopEvent gPSStopEvent = new GPSStopEvent(player, GPSStopEvent.StopSource.PLUGIN);
            Bukkit.getPluginManager().callEvent((Event)gPSStopEvent);
            this.playerData.exitNavigation();
            MessagesFile.getInstance().getCantReachDestination().send(player);
            return;
        }
        if (Vars.getInstance().isCompassItemEnabled() && !CompassItem.canGiveCompass(player)) {
            GPSStopEvent gPSStopEvent = new GPSStopEvent(player, GPSStopEvent.StopSource.PLUGIN);
            Bukkit.getPluginManager().callEvent((Event)gPSStopEvent);
            this.playerData.exitNavigation();
            MessagesFile.getInstance().getCantGiveCompassItem().send(player);
            return;
        }
        this.evaluateFinalPath();
        if (this.startMessage == null) {
            (this.playerData.isCompassMode() ? MessagesFile.getInstance().getStartedCompass() : MessagesFile.getInstance().getStartedGPS()).send(player);
        } else {
            StringUtil.msgSend(player, this.startMessage);
        }
        this.startGPS();
    }

    private void evaluateFinalPath() {
        if (this.playerData.isCompassMode() || this.path.size() == 1) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        ArrayList<Point> arrayList = new ArrayList<Point>(this.path);
        arrayList.remove(0);
        this.path = (d2 += this.calculateDistance(arrayList)) < (d += this.calculateDistance(this.path)) ? arrayList : this.path;
    }

    private void startGPS() {
        long l;
        boolean bl;
        this.playerData.setGpsActive(true);
        this.currentTarget = this.path.get(0);
        if (!this.playerData.getPlayer().getWorld().equals(this.currentTarget.getLocation().getWorld())) {
            this.path.add(0, this.start);
            this.currentTarget = this.path.get(0);
        }
        CompassItem.setCompassTarget(this.playerData.getPlayer(), this.currentTarget.getLocation());
        this.playerData.setTargetLocation(this.currentTarget.getLocation());
        this.playerData.getArrow().setRemainingDistanceToTarget(this.calculateDistance(null));
        this.playerData.getArrow().setTotalDistanceToTarget(this.playerData.getArrow().getRemainingDistanceToTarget());
        this.playerData.getBossBarTracker().update();
        boolean bl2 = bl = Vars.getInstance().isAutoShow() && PluginPermission.SHOW.hasPermission((Permissible)this.playerData.getPlayer());
        if (bl) {
            l = Vars.getInstance().getParticleUpdateRate();
            BukkitTask bukkitTask = new BukkitRunnable(){

                public void run() {
                    if (Path.this.playerData.getPlayer() == null || !Path.this.playerData.getPlayer().isOnline()) {
                        return;
                    }
                    new ParticleUtil(Path.this.playerData.getPlayer(), Path.this.playerData.getPath().getPath()).highlightPath();
                }
            }.runTaskTimer((Plugin)Main.getPlugin(Main.class), 0L, l);
            this.playerData.setVisualPathTask(bukkitTask);
        }
        l = Vars.getInstance().getGpsUpdateInterval();
        CompassItem.giveCompass(this.playerData.getPlayer());
        this.task = new BukkitRunnable(){
            private int index = 0;
            private boolean onPath = false;

            public void run() {
                if (Path.this.playerData.getPlayer() == null || !Path.this.playerData.getPlayer().isOnline()) {
                    return;
                }
                for (Point point : GPSManager.getInstance().getGlobalPoints()) {
                    if (Path.this.path == null || !this.isInUpdateDistance(Path.this.playerData.getPlayer(), point) && point != Path.this.path.get(this.index)) continue;
                    if (point == Path.this.path.get(this.index) && this.onPath && !Path.this.playerData.isCompassMode()) {
                        if (this.checkCourse(point)) {
                            this.onPath = false;
                            this.updateCurrentPath(point);
                            Path.this.currentTarget = (Point)Path.this.path.get(this.index);
                            Path.this.playerData.setTargetLocation(Path.this.currentTarget.getLocation());
                            continue;
                        }
                    } else if (!this.isInUpdateDistance(Path.this.playerData.getPlayer(), point)) continue;
                    if (point.equals(Path.this.end)) {
                        CompassItem.setCompassTarget(Path.this.playerData.getPlayer(), Path.this.playerData.getPlayer().getWorld().getSpawnLocation());
                        Path.this.fireStopEvent(point);
                        return;
                    }
                    CompassItem.setCompassTarget(Path.this.playerData.getPlayer(), Path.this.currentTarget.getLocation());
                    if (Path.this.playerData.isCompassMode()) {
                        return;
                    }
                    if (Path.this.path.size() > 1) {
                        if (point.equals(Path.this.path.get(this.index + 1))) {
                            ++this.index;
                        } else {
                            this.updateCurrentPath(point);
                        }
                    } else {
                        this.updateCurrentPath(point);
                    }
                    if (Path.this.path.size() <= 1) continue;
                    if (!((Point)Path.this.path.get(this.index + 1)).getLocation().getWorld().equals(Path.this.playerData.getPlayer().getWorld())) {
                        Path.this.currentTarget = (Point)Path.this.path.get(this.index);
                    } else {
                        Path.this.currentTarget = (Point)Path.this.path.get(this.index + 1);
                    }
                    Path.this.playerData.setTargetLocation(Path.this.currentTarget.getLocation());
                    CompassItem.setCompassTarget(Path.this.playerData.getPlayer(), Path.this.currentTarget.getLocation());
                    this.onPath = true;
                }
                if (Path.this.playerData.isCompassMode() && Path.this.playerData.getPlayer().getLocation().distance(Path.this.end.getLocation()) < Path.this.end.getUpdateDistance()) {
                    Path.this.fireStopEvent(Path.this.end);
                }
            }

            private boolean checkCourse(Point point) {
                if (this.isInUpdateDistance(Path.this.playerData.getPlayer(), point)) {
                    return false;
                }
                double d = point.distance(Path.this.playerData.getTargetLocation());
                double d2 = Path.this.playerData.getPlayer().getWorld().equals(Path.this.playerData.getTargetLocation().getWorld()) ? Path.this.playerData.getPlayer().getLocation().distance(Path.this.playerData.getTargetLocation()) : Vars.getInstance().getTeleportConnectionDistance();
                return d2 > d + point.getUpdateDistance();
            }

            private void updateCurrentPath(Point point) {
                List<Point> list;
                if (Path.this.pathCache.containsKey(point.getSection())) {
                    list = (List<Point>)Path.this.pathCache.get(point.getSection());
                    if (list != null) {
                        Path.this.path = list;
                        this.index = 0;
                        return;
                    }
                    Path.this.pathCache.remove(point.getSection());
                }
                if ((list = new Computation(point, Path.this.end).getShortestPath()) != null) {
                    Path.this.pathCache.put(list.get(0).getSection(), list);
                    Path.this.path = list;
                    this.index = 0;
                }
            }

            private boolean isInUpdateDistance(Player player, Point point) {
                return player.getLocation().getWorld().equals(point.getLocation().getWorld()) && point.distance(player.getLocation()) <= point.getUpdateDistance();
            }
        }.runTaskTimer((Plugin)Main.getPlugin(Main.class), 0L, l);
    }

    private void fireStopEvent(Point point) {
        GPSStopEvent gPSStopEvent = new GPSStopEvent(this.playerData.getPlayer(), GPSStopEvent.StopSource.DESTINATION_REACHED, this.playerData.isCompassMode());
        Bukkit.getPluginManager().callEvent((Event)gPSStopEvent);
        StringUtil.msgSend(this.playerData.getPlayer(), gPSStopEvent.getCustomStopMessage() == null ? (point.hasCustomDestinationMessage() ? point.getCustomDestinationMessage() : MessagesFile.getInstance().getDestinationReached().toString()) : gPSStopEvent.getCustomStopMessage());
        Optional.ofNullable(point.getDestinationSound()).ifPresent(string -> this.playerData.getPlayer().playSound(point.getLocation(), Sound.valueOf((String)point.getDestinationSound()), 1.0f, 1.0f));
        this.playerData.exitNavigation();
    }

    private Point findClosestEntryPoint() {
        double d;
        HashMap<Double, Point> hashMap = new HashMap<Double, Point>();
        for (Point object2 : GPSManager.getInstance().getGlobalPoints()) {
            if (object2.getLocation().getWorld() != this.playerData.getPlayer().getLocation().getWorld() || (d = object2.getLocation().distance(this.playerData.getPlayer().getLocation())) > Vars.getInstance().getMaxDistanceToEntry()) continue;
            hashMap.put(d, object2);
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            d = (Double)iterator.next();
            if (((Point)hashMap.get(d)).equals(this.end)) {
                return this.end;
            }
            if (new Computation((Point)hashMap.get(d), this.end).getShortestPath() == null) continue;
            return (Point)hashMap.get(d);
        }
        return (Point)hashMap.get(arrayList.get(0));
    }

    public double calculateDistance(List<Point> list) {
        ArrayList<Point> arrayList = new ArrayList<Point>(list == null ? this.path : list);
        Collections.reverse(arrayList);
        double d = 0.0;
        Point point = (Point)arrayList.get(0);
        if (arrayList.size() > 2 || !point.equals(this.currentTarget)) {
            for (int i = 1; i < arrayList.size(); ++i) {
                Point point2 = (Point)arrayList.get(i);
                d += point.distance(point2);
                point = (Point)arrayList.get(i);
                if (point.getLocation().equals((Object)this.playerData.getTargetLocation()) && list == null) break;
            }
        }
        return d += point.distance(this.playerData.getPlayer().getLocation());
    }

    public void cancel() {
        if (this.task == null) {
            return;
        }
        this.task.cancel();
    }

    public Point getEnd() {
        return this.end;
    }

    public List<Point> getPath() {
        return this.path;
    }

    public Point getCurrentTarget() {
        return this.currentTarget;
    }
}

