/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.logic;

import com.live.bemmamin.gps.files.PointsFile;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class GPSManager {
    private static GPSManager gpsManager = null;
    private final LinkedHashMap<Plugin, ArrayList<Point>> externalPoints = new LinkedHashMap();
    private Map<String, String> legacyConnectionMap = new HashMap<String, String>();
    private List<Point> configurationPoints = new ArrayList<Point>();

    public static GPSManager getInstance() {
        gpsManager = gpsManager == null ? new GPSManager() : gpsManager;
        return gpsManager;
    }

    public List<Point> getGlobalPoints() {
        ArrayList<Point> arrayList = new ArrayList<Point>(this.configurationPoints);
        this.externalPoints.values().forEach(arrayList::addAll);
        return arrayList;
    }

    public List<Point> getLocalPoints() {
        return new ArrayList<Point>(this.configurationPoints);
    }

    public void loadConfigurationPoints() {
        this.configurationPoints = new ArrayList<Point>();
        for (String object : PointsFile.getInstance().getConfig().getConfigurationSection("Points").getKeys(false)) {
            Point point = new Point(PointsFile.getInstance().getConfig().getConfigurationSection("Points." + object));
            if (point.getLocation() == null) continue;
            this.configurationPoints.add(point);
        }
        this.checkLegacyPoints();
        for (Point point : this.configurationPoints) {
            point.setConnections();
        }
        if (!this.legacyConnectionMap.isEmpty()) {
            StringUtil.msgSend(null, "&7[&eGPS&7] &a>> &e" + this.legacyConnectionMap.size() + " &aPoints have been migrated to the new system! :)");
            this.legacyConnectionMap = new HashMap<String, String>();
            this.loadConfigurationPoints();
        }
    }

    public boolean containsPoint(String string, boolean bl) {
        for (Point point : this.getGlobalPoints()) {
            if (bl && point.hasName() && point.getName().equalsIgnoreCase(string)) {
                return true;
            }
            if (bl || !point.getSection().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Point getPointByName(String string) {
        for (Point point : this.getGlobalPoints()) {
            if (!point.hasName() || !point.getName().equalsIgnoreCase(string)) continue;
            return point;
        }
        return null;
    }

    private void checkLegacyPoints() {
        if (this.legacyConnectionMap.isEmpty()) {
            return;
        }
        FileConfiguration fileConfiguration = PointsFile.getInstance().getConfig();
        for (String string : fileConfiguration.getConfigurationSection("Points").getKeys(false)) {
            if (!fileConfiguration.contains("Points." + string + ".connections")) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : fileConfiguration.getStringList("Points." + string + ".connections")) {
                arrayList.add(this.legacyConnectionMap.getOrDefault(string2, string2));
            }
            fileConfiguration.set("Points." + string + ".connections", arrayList);
        }
        PointsFile.getInstance().save();
    }

    public LinkedHashMap<Plugin, ArrayList<Point>> getExternalPoints() {
        return this.externalPoints;
    }

    public Map<String, String> getLegacyConnectionMap() {
        return this.legacyConnectionMap;
    }
}

