/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.logic;

import com.live.bemmamin.gps.logic.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Computation {
    private final Point start;
    private final Point destination;
    private final Set<Point> resolvedPoints = new HashSet<Point>();
    private final Set<Point> unResolvedPoints = new HashSet<Point>();
    private final Map<Point, Point> predecessors = new HashMap<Point, Point>();
    private final Map<Point, Double> distances = new HashMap<Point, Double>();

    public Computation(Point point, Point point2) {
        this.start = point;
        this.destination = point2;
    }

    public List<Point> getShortestPath() {
        this.computeShortestPath();
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Point point = this.destination;
        if (this.predecessors.get(point) == null) {
            return null;
        }
        arrayList.add(point);
        while (this.predecessors.get(point) != null) {
            point = this.predecessors.get(point);
            arrayList.add(point);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private void computeShortestPath() {
        this.distances.put(this.start, 0.0);
        this.unResolvedPoints.add(this.start);
        while (!this.unResolvedPoints.isEmpty()) {
            Point point = this.getMin();
            this.resolvedPoints.add(point);
            this.unResolvedPoints.remove(point);
            this.findMinDistances(point);
        }
    }

    private void findMinDistances(Point point) {
        List<Point> list = this.connections(point);
        for (Point point2 : list) {
            double d = this.getShortestDistance(point) + point.distance(point2);
            if (!(this.getShortestDistance(point2) > d)) continue;
            this.distances.put(point2, d);
            this.predecessors.put(point2, point);
            this.unResolvedPoints.add(point2);
        }
    }

    private List<Point> connections(Point point) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (Point point2 : point.getConnections()) {
            if (this.resolvedPoints.contains(point2)) continue;
            arrayList.add(point2);
        }
        return arrayList;
    }

    private Point getMin() {
        Point point = null;
        for (Point point2 : this.unResolvedPoints) {
            if (point == null) {
                point = point2;
                continue;
            }
            if (!(this.getShortestDistance(point2) < this.getShortestDistance(point))) continue;
            point = point2;
        }
        return point;
    }

    private double getShortestDistance(Point point) {
        Double d = this.distances.get(point);
        return d == null ? Double.MAX_VALUE : d;
    }
}

