/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.logic;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.StringUtil;
import java.util.Collections;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class BossBarTracker {
    private final PlayerData playerData;
    private int bossBarCompassSeparatorLength;
    private String compassText;
    private BossBar bossBar;

    public BossBarTracker(PlayerData playerData) {
        this.playerData = playerData;
        this.setCompassText();
    }

    private void setCompassText() {
        this.bossBarCompassSeparatorLength = Vars.getInstance().getBossBarCompassSeparatorLength();
        this.compassText = "N_E_S_W_".chars().mapToObj(n -> n == 95 ? String.join((CharSequence)"", Collections.nCopies(this.bossBarCompassSeparatorLength, "_")) : String.valueOf((char)n)).collect(Collectors.joining());
    }

    public void update() {
        if (Vars.getInstance().getBossBarCompassSeparatorLength() != this.bossBarCompassSeparatorLength) {
            this.setCompassText();
        }
        if (!Vars.getInstance().isBossBarEnabled()) {
            return;
        }
        this.bossBar = this.bossBar == null ? Bukkit.createBossBar((String)"", (BarColor)Vars.getInstance().getBossBarColor(), (BarStyle)Vars.getInstance().getBossBarStyle(), (BarFlag[])new BarFlag[0]) : this.bossBar;
        this.bossBar.setProgress(this.playerData.getArrow().getRemainingDistanceToTarget() / this.playerData.getArrow().getTotalDistanceToTarget());
        if (!Vars.getInstance().isBossBarCompassEnabled()) {
            String string = StringUtil.translate(Vars.getInstance().getBossBarMessage().replace("%remaining%", StringUtil.formatDouble(this.playerData.getArrow().getRemainingDistanceToTarget())).replace("%remainingTenth%", StringUtil.formatDouble(this.playerData.getArrow().getRemainingDistanceToTarget()).substring(0, StringUtil.formatDouble(this.playerData.getArrow().getRemainingDistanceToTarget()).length() - 1)).replace("%remainingRounded%", StringUtil.formatDouble(this.playerData.getArrow().getRemainingDistanceToTarget()).substring(0, StringUtil.formatDouble(this.playerData.getArrow().getRemainingDistanceToTarget()).length() - 3)).replace("%total%", StringUtil.formatDouble(this.playerData.getArrow().getTotalDistanceToTarget())).replace("%totalTenth%", StringUtil.formatDouble(this.playerData.getArrow().getTotalDistanceToTarget()).substring(0, StringUtil.formatDouble(this.playerData.getArrow().getTotalDistanceToTarget()).length() - 1)).replace("%totalRounded%", StringUtil.formatDouble(this.playerData.getArrow().getTotalDistanceToTarget()).substring(0, StringUtil.formatDouble(this.playerData.getArrow().getTotalDistanceToTarget()).length() - 3)));
            if (Main.isPlaceHolderAPIEnabled()) {
                string = PlaceholderAPI.setPlaceholders((Player)this.playerData.getPlayer(), (String)string);
            }
            this.bossBar.setTitle(string);
        } else {
            this.bossBar.setTitle(this.getCompassString());
        }
        this.bossBar.addPlayer(this.playerData.getPlayer());
    }

    private String getCompassString() {
        Location location = this.playerData.getTargetLocation();
        Location location2 = this.playerData.getPlayer().getLocation();
        Vector vector = location.clone().subtract(location2).toVector().setY(0);
        Vector vector2 = location2.getDirection().clone().setY(0);
        double d = (double)vector2.angle(vector) / Math.PI * 180.0;
        d = vector.crossProduct(vector2).getY() > 0.0 ? -d : d;
        float f = (this.playerData.getPlayer().getLocation().getYaw() - 180.0f) % 360.0f;
        if (f < 0.0f) {
            f = (float)((double)f + 360.0);
        }
        int n = (int)(f / (360.0f / (float)this.compassText.length()));
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = ChatColor.stripColor((String)StringUtil.translate(Vars.getInstance().getBossBarCompassPrefix())).length() + ChatColor.stripColor((String)StringUtil.translate(Vars.getInstance().getBossBarCompassSuffix())).length();
        int n3 = Vars.getInstance().getBossBarCompassTotalLength() - n2;
        for (int i = n - (int)Math.floor((double)n3 / 2.0); i < n + (int)Math.ceil((double)n3 / 2.0); ++i) {
            if (i < 0) {
                stringBuilder.append(this.compassText.charAt(this.compassText.length() + i));
                continue;
            }
            stringBuilder.append(this.compassText.charAt(i % this.compassText.length()));
        }
        double d2 = 300.0;
        if (Math.abs(d) < 150.0) {
            d = Math.floor(d + 150.0);
            double d3 = 300.0 / (double)n3;
            int n4 = Math.abs((int)Math.floor(d / d3) - n3 - 1);
            stringBuilder.setCharAt(Math.min(n4, n3 - 1), 'X');
        }
        String string = stringBuilder.toString();
        string = string.replace("_", Vars.getInstance().getBossBarCompassSeparator());
        string = string.replace("N", Vars.getInstance().getBossBarCompassNorth());
        string = string.replace("S", Vars.getInstance().getBossBarCompassSouth());
        string = string.replace("W", Vars.getInstance().getBossBarCompassWest());
        string = string.replace("E", Vars.getInstance().getBossBarCompassEast());
        string = string.replace("X", Math.abs(location.getBlockY() - location2.getBlockY()) <= Vars.getInstance().getBossBarCompassTargetOffset() ? Vars.getInstance().getBossBarCompassTarget() : (location.getBlockY() - location2.getBlockY() > 0 ? Vars.getInstance().getBossBarCompassTargetAbove() : Vars.getInstance().getBossBarCompassTargetBelow()));
        return StringUtil.translate(Vars.getInstance().getBossBarCompassPrefix() + string + Vars.getInstance().getBossBarCompassSuffix());
    }

    public void remove() {
        if (this.bossBar == null) {
            return;
        }
        if (this.playerData.getPlayer() != null && this.playerData.getPlayer().isOnline()) {
            this.bossBar.removePlayer(this.playerData.getPlayer());
        }
        this.bossBar = null;
    }
}

