/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.files;

import com.live.bemmamin.gps.Main;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class FileHandler {
    private final File file;
    private final FileConfiguration config;

    FileHandler(String string) {
        this(string, false);
    }

    FileHandler(String string, boolean bl) {
        Main main = (Main)Main.getPlugin(Main.class);
        this.file = new File(main.getDataFolder(), string);
        if (!this.file.exists()) {
            if (!bl) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                main.saveResource(string, false);
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    Object add(String string, Object object) {
        if (this.config.contains(string)) {
            return this.config.get(string);
        }
        this.config.set(string, object);
        return object;
    }

    void setHeader(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append("\n");
        }
        this.config.options().header(String.valueOf(stringBuilder));
    }

    public abstract void load();

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

