/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.files;

import com.live.bemmamin.gps.files.FileHandler;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;

public final class CrashSafetyFile
extends FileHandler {
    private static final CrashSafetyFile instance = new CrashSafetyFile();

    private CrashSafetyFile() {
        super("crashSafety.yml");
        this.load();
    }

    @Override
    public void load() {
        this.setHeader("This is a crash safety storage file for GPS arrow entity UUIDs.\n\nOnce an arrow is created the entity UUIDs are stored internally and in this file.\nThe UUIDs are then removed once the GPS arrow is stopped.\nThe UUIDs will remain in this file and is not lost should the server unexpectedly crash for whatever reason.\nThis file is checked on restart. If the server contains an entity with the given UUID it is removed.\n\nDo NOT edit this file manually unless you know exactly what you are doing.\n");
        if (!this.getConfig().contains("EntityUUIDs")) {
            this.getConfig().set("EntityUUIDs.init", (Object)"init");
            this.getConfig().set("EntityUUIDs.init", null);
        }
        this.save();
    }

    public void saveUUIDs(List<ArmorStand> list) {
        List<String> list2 = this.getEntityUUIDs();
        list.stream().filter(armorStand -> !list2.contains(armorStand.getUniqueId().toString())).forEach(armorStand -> list2.add(armorStand.getUniqueId().toString()));
        this.getConfig().set("EntityUUIDs", list2);
        this.save();
    }

    public void crashCheckEntities() {
        List<String> list = this.getEntityUUIDs();
        Bukkit.getWorlds().forEach(world -> world.getEntities().stream().filter(entity -> entity instanceof ArmorStand && list.contains(entity.getUniqueId().toString())).forEach(Entity::remove));
        this.getConfig().set("EntityUUIDs", null);
        this.getConfig().set("EntityUUIDs.init", (Object)"init");
        this.getConfig().set("EntityUUIDs.init", null);
        this.save();
    }

    public void removeEntities(List<ArmorStand> list) {
        List<String> list2 = this.getEntityUUIDs();
        list.forEach(armorStand -> list2.remove(armorStand.getUniqueId().toString()));
        this.getConfig().set("EntityUUIDs", list2);
        this.save();
    }

    private List<String> getEntityUUIDs() {
        return new ArrayList<String>(this.getConfig().getStringList("EntityUUIDs"));
    }

    public static CrashSafetyFile getInstance() {
        return instance;
    }
}

