/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.events;

import com.live.bemmamin.gps.Enums;
import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.files.CrashSafetyFile;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.logic.Computation;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.GPSUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.plugin.Plugin;

public class WorldChangeListener
implements Listener {
    private final Main main;

    public WorldChangeListener(Main main) {
        this.main = main;
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        PlayerData playerData = PlayerData.getPlayerData(player);
        if (!playerData.isGpsActive()) {
            return;
        }
        Optional<Point> optional = GPSManager.getInstance().getGlobalPoints().stream().filter(point -> point.getLocation().getWorld().equals(player.getWorld())).filter(point -> point.distance(player.getLocation()) <= point.getUpdateDistance()).findFirst();
        if (playerData.isCompassMode() || !optional.isPresent() || !optional.get().equals(playerData.getPath().getPath().get(playerData.getPath().getPath().size() - 1)) && new Computation(optional.get(), playerData.getPath().getPath().get(playerData.getPath().getPath().size() - 1)).getShortestPath() == null) {
            playerData.exitNavigation();
            MessagesFile.getInstance().getNoEntry().send(player);
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> {
            if (!player.isOnline()) {
                return;
            }
            List<ArmorStand> list = playerData.getStands();
            list.forEach(Entity::remove);
            CrashSafetyFile.getInstance().removeEntities(list);
            list.clear();
            playerData.getArrow().setComponents(new LinkedHashMap<Location, Enums.ComponentType>());
            GPSUtil.update(player);
        }, 10L);
    }
}

