/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.events;

import com.live.bemmamin.gps.Enums;
import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.files.CrashSafetyFile;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.GPSUtil;
import java.util.LinkedHashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class PlayerTeleportListener
implements Listener {
    private final Main main;

    public PlayerTeleportListener(Main main) {
        this.main = main;
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent playerTeleportEvent) {
        double d;
        if (playerTeleportEvent == null) {
            return;
        }
        if (playerTeleportEvent.getPlayer() == null) {
            return;
        }
        Player player = playerTeleportEvent.getPlayer();
        PlayerData playerData = PlayerData.getPlayerData(player);
        if (playerData.getAbstractArrow() == null) {
            return;
        }
        try {
            d = playerTeleportEvent.getFrom().distance(playerTeleportEvent.getTo());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        if (d > 20.0) {
            List<ArmorStand> list = playerData.getStands();
            list.forEach(Entity::remove);
            CrashSafetyFile.getInstance().removeEntities(list);
            list.clear();
            playerData.getArrow().setComponents(new LinkedHashMap<Location, Enums.ComponentType>());
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> {
            if (!player.isOnline()) {
                return;
            }
            GPSUtil.update(player);
        }, 3L);
    }
}

