/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.events;

import com.live.bemmamin.gps.Enums;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.api.events.GPSStopEvent;
import com.live.bemmamin.gps.files.CrashSafetyFile;
import com.live.bemmamin.gps.logic.CompassItem;
import com.live.bemmamin.gps.playerdata.PlayerData;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerQuitListener
implements Listener {
    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        if (playerQuitEvent == null || playerQuitEvent.getPlayer() == null) {
            return;
        }
        Player player = playerQuitEvent.getPlayer();
        PlayerData playerData = PlayerData.getPlayerData(player);
        if (!playerData.isGpsActive()) {
            return;
        }
        CompassItem.removeCompass(player);
        CompassItem.setCompassTarget(player, player.getWorld().getSpawnLocation());
        if (!Vars.getInstance().isSaveOnQuit()) {
            GPSStopEvent gPSStopEvent = new GPSStopEvent(player);
            Bukkit.getPluginManager().callEvent((Event)gPSStopEvent);
            playerData.exitNavigation();
        } else {
            playerData.getStands().forEach(Entity::remove);
            CrashSafetyFile.getInstance().removeEntities(playerData.getStands());
            playerData.setStands(new ArrayList<ArmorStand>());
            playerData.getArrow().setComponents(new LinkedHashMap<Location, Enums.ComponentType>());
            playerData.setQuitTime(Instant.now().getEpochSecond());
            playerData.setIdle(true);
        }
    }
}

