/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.events;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.configurator.ConfiguratorStickManager;
import com.live.bemmamin.gps.playerdata.ConfiguratorData;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.GPSUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerMoveListener
implements Listener {
    private final Main main;

    public PlayerMoveListener(Main main) {
        this.main = main;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent playerMoveEvent) {
        PlayerData playerData;
        if (playerMoveEvent == null) {
            return;
        }
        if (playerMoveEvent.getPlayer() == null) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        if (PlayerData.contains(player) && (playerData = PlayerData.getPlayerData(player)).isGpsActive()) {
            this.main.getInactivityTimer().updatePlayer(player.getUniqueId());
            if (!Vars.getInstance().isParticleArrow()) {
                playerData.setMovementSpeed(playerMoveEvent.getFrom().distance(playerMoveEvent.getTo()));
            }
        }
        if (ConfiguratorData.contains(player)) {
            ConfiguratorData.getConfiguratorData(player).setClosestPoint(GPSUtil.closestPoint(player));
            if (player.getInventory().getItemInHand() != null && player.getInventory().getItemInHand().hasItemMeta() && player.getInventory().getItemInHand().getItemMeta().hasDisplayName()) {
                if (!player.getItemInHand().getItemMeta().getDisplayName().contains(ConfiguratorStickManager.getHiddenIdentifier()) || !ConfiguratorData.getConfiguratorData(player).isEditorActivated()) {
                    return;
                }
                ConfiguratorData.getConfiguratorData(player).startStickSelectionTask();
            }
        }
    }
}

