/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.events;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.logic.CompassItem;
import com.live.bemmamin.gps.playerdata.PlayerData;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerJoinListener
implements Listener {
    private final Main main;

    public PlayerJoinListener(Main main) {
        this.main = main;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        if (playerJoinEvent == null || playerJoinEvent.getPlayer() == null) {
            return;
        }
        Player player = playerJoinEvent.getPlayer();
        PlayerData playerData = PlayerData.getPlayerData(player);
        if (Main.getEntityHider() != null) {
            for (ArmorStand armorStand : Vars.getInstance().getStandMap().values()) {
                Main.getEntityHider().hideEntity(player, (Entity)armorStand);
            }
        }
        if (!playerData.isIdle()) {
            return;
        }
        playerData.setIdle(false);
        Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> {
            if (!player.isOnline()) {
                return;
            }
            if (playerData.isGpsActive()) {
                MessagesFile.getInstance().getResuming().send(player);
                CompassItem.giveCompass(player);
                CompassItem.setCompassTarget(player, playerData.getTargetLocation());
            } else {
                MessagesFile.getInstance().getEnded().send(player);
            }
        }, 5L);
    }
}

