/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.events;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.utils.TagUtil;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class EnderPearlListener
implements Listener {
    private static final int TOLERANCE = 2;
    private final Main main;

    public EnderPearlListener(Main main) {
        this.main = main;
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent playerTeleportEvent) {
        if (playerTeleportEvent.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            return;
        }
        List list = playerTeleportEvent.getTo().getWorld().getEntities().stream().filter(entity -> entity instanceof ArmorStand && TagUtil.isTagged(entity)).map(Entity::getLocation).collect(Collectors.toList());
        playerTeleportEvent.getTo().getWorld().getEntities().stream().filter(EnderPearl.class::isInstance).map(EnderPearl.class::cast).filter(enderPearl -> list.stream().anyMatch(location -> enderPearl.getLocation().distance(location) < 2.0)).min(Comparator.comparingDouble(enderPearl -> enderPearl.getLocation().distance(playerTeleportEvent.getTo()))).ifPresent(enderPearl -> {
            playerTeleportEvent.setCancelled(true);
            Bukkit.getScheduler().runTask((Plugin)this.main, () -> {
                Location location = enderPearl.getLocation().clone();
                EnderPearl enderPearl2 = (EnderPearl)location.getWorld().spawn(location, EnderPearl.class);
                enderPearl2.setShooter((ProjectileSource)playerTeleportEvent.getPlayer());
                enderPearl2.setVelocity(enderPearl.getVelocity());
                enderPearl.remove();
            });
        });
    }
}

