/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.events;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.api.events.GPSStartEvent;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.playerdata.PlayerData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class DeathTargetListeners
implements Listener {
    private final Map<UUID, Location> deathLocations = new HashMap<UUID, Location>();
    private final Main main;

    public DeathTargetListeners(Main main) {
        this.main = main;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent playerDeathEvent) {
        if (Vars.getInstance().isStartOnDeath() && PluginPermission.GPS_START_ON_RESPAWN.hasPermission((Permissible)playerDeathEvent.getEntity()) && (!Vars.getInstance().isContinueOnRespawn() || !PlayerData.getPlayerData(playerDeathEvent.getEntity()).isGpsActive())) {
            this.deathLocations.put(playerDeathEvent.getEntity().getUniqueId(), playerDeathEvent.getEntity().getLocation());
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        Location location = this.deathLocations.get(player.getUniqueId());
        if (location != null && location.getWorld().equals(playerRespawnEvent.getRespawnLocation().getWorld())) {
            this.startNavigation(player, location);
        } else if (!Vars.getInstance().isStartOnDeathWorldReentry()) {
            this.deathLocations.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerChangeWorld(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        Location location = this.deathLocations.get(player.getUniqueId());
        if (location != null && location.getWorld().equals(playerChangedWorldEvent.getPlayer().getWorld())) {
            this.startNavigation(player, location);
        }
    }

    private void startNavigation(Player player, Location location) {
        Point point = new Point("", location);
        GPSStartEvent gPSStartEvent = new GPSStartEvent(player, point, GPSStartEvent.StartSource.PLAYER_RESPAWN, true);
        Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
        if (!gPSStartEvent.isCancelled()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.main, () -> PlayerData.getPlayerData(player).startNavigation(point, true, MessagesFile.getInstance().getStartedCompassOnRespawn().toString()));
        }
        this.deathLocations.remove(player.getUniqueId());
    }
}

