/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.events;

import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.configurator.ConfiguratorStickManager;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.playerdata.ConfiguratorData;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.permissions.Permissible;

public class ConfiguratorUseListener
implements Listener {
    @EventHandler
    public void onConfiguratorUse(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent == null) {
            return;
        }
        if (playerInteractEvent.getItem() == null) {
            return;
        }
        if (playerInteractEvent.getItem().getType() != Material.STICK) {
            return;
        }
        if (!playerInteractEvent.getItem().hasItemMeta()) {
            return;
        }
        if (!playerInteractEvent.getItem().getItemMeta().hasDisplayName()) {
            return;
        }
        if (!playerInteractEvent.getItem().getItemMeta().getDisplayName().contains(ConfiguratorStickManager.getHiddenIdentifier())) {
            return;
        }
        playerInteractEvent.setCancelled(true);
        Player player = playerInteractEvent.getPlayer();
        if (!PluginPermission.GPS_CONFIGURATOR.hasPermission((Permissible)player) && !player.isOp()) {
            MessagesFile.getInstance().getInvalidPermission().replace("%prefix%", "%confPrefix%").send(player);
            return;
        }
        if (!ConfiguratorData.getConfiguratorData(player).isEditorActivated()) {
            MessagesFile.getInstance().getEditorInactive().send(player);
            return;
        }
        ConfiguratorStickManager configuratorStickManager = new ConfiguratorStickManager();
        switch (playerInteractEvent.getAction()) {
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: {
                if (!player.isSneaking()) {
                    configuratorStickManager.selectOrCreatePoint(player);
                    break;
                }
                configuratorStickManager.deleteTargetPoint(player);
                break;
            }
            case RIGHT_CLICK_BLOCK: 
            case RIGHT_CLICK_AIR: {
                if (!player.isSneaking()) {
                    configuratorStickManager.connectPoint(player);
                    break;
                }
                configuratorStickManager.disconnectPoint(player);
            }
        }
    }
}

