/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.events;

import com.live.bemmamin.gps.logic.CompassItem;
import com.live.bemmamin.gps.playerdata.PlayerData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;

public class CompassItemListener
implements Listener {
    @EventHandler
    public void onPlayerCompassEvent(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent == null || inventoryClickEvent.getWhoClicked() == null || !(inventoryClickEvent.getWhoClicked() instanceof Player)) {
            return;
        }
        if (inventoryClickEvent.isShiftClick() && CompassItem.equals(inventoryClickEvent.getCurrentItem())) {
            inventoryClickEvent.setCancelled(true);
            inventoryClickEvent.setResult(Event.Result.DENY);
            return;
        }
        ItemStack itemStack = inventoryClickEvent.getCursor();
        if (!itemStack.hasItemMeta() || !itemStack.getItemMeta().hasDisplayName()) {
            return;
        }
        if (CompassItem.equals(itemStack)) {
            if (inventoryClickEvent.getSlotType() == InventoryType.SlotType.OUTSIDE) {
                PlayerData playerData = PlayerData.getPlayerData((Player)inventoryClickEvent.getWhoClicked());
                if (playerData.isGpsActive()) {
                    playerData.exitNavigation();
                }
            } else if (inventoryClickEvent.getRawSlot() == inventoryClickEvent.getSlot()) {
                inventoryClickEvent.setCancelled(true);
                inventoryClickEvent.setResult(Event.Result.DENY);
            }
        }
    }

    @EventHandler
    public void onPlayerCompassEvent(PlayerDropItemEvent playerDropItemEvent) {
        if (playerDropItemEvent == null || playerDropItemEvent.getItemDrop() == null || playerDropItemEvent.getItemDrop().getItemStack() == null) {
            return;
        }
        ItemStack itemStack = playerDropItemEvent.getItemDrop().getItemStack();
        if (!itemStack.hasItemMeta() || !itemStack.getItemMeta().hasDisplayName()) {
            return;
        }
        if (CompassItem.equals(itemStack)) {
            playerDropItemEvent.getItemDrop().remove();
            PlayerData playerData = PlayerData.getPlayerData(playerDropItemEvent.getPlayer());
            if (playerData.isGpsActive()) {
                playerData.exitNavigation();
            }
        }
    }
}

