/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.dynmap;

import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.files.DynmapFile;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.PolyLineMarker;

public class DynmapHook {
    private final DynmapAPI dynmap = (DynmapAPI)Bukkit.getServer().getPluginManager().getPlugin("dynmap");
    private String name;
    private double pointRadius;
    private double pointFillOpacity;
    private int pointFillColor;
    private boolean pointMarkersEnabled;
    private int pointBorderWeight;
    private double pointBorderOpacity;
    private int pointBorderColor;
    private String pointMarkupDescription;
    private MarkerSet markerSet = null;
    private boolean connectionMarkersEnabled;
    private int connectionLineWeight;
    private double connectionLineOpacity;
    private int connectionLineColor;

    public void updateDynmapGPS() {
        this.loadConfigVariables();
        if (this.markerSet != null) {
            this.markerSet.deleteMarkerSet();
        }
        this.markerSet = this.dynmap.getMarkerAPI().createMarkerSet("GPS_PLUGIN", this.name, this.dynmap.getMarkerAPI().getMarkerIcons(), false);
        if (this.markerSet != null) {
            int n = 0;
            for (Point point : GPSManager.getInstance().getGlobalPoints()) {
                Location location = point.getLocation();
                if (this.pointMarkersEnabled) {
                    double d = this.pointRadius == Vars.getInstance().getPointUpdateDistance() ? point.getUpdateDistance() : this.pointRadius;
                    Object object = this.markerSet.createCircleMarker("DMID: " + n++, "", true, location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), d, d, false);
                    object.setLabel(this.translateDescriptionPlaceholders(point), true);
                    object.setFillStyle(this.pointFillOpacity, this.pointFillColor);
                    object.setLineStyle(this.pointBorderWeight, this.pointBorderOpacity, this.pointBorderColor);
                }
                if (!this.connectionMarkersEnabled) continue;
                PolyLineMarker polyLineMarker = this.markerSet.createPolyLineMarker("DMID: " + n++, "", false, location.getWorld().getName(), new double[0], new double[0], new double[0], false);
                polyLineMarker.setLineStyle(this.connectionLineWeight, this.connectionLineOpacity, this.connectionLineColor);
                polyLineMarker.setCornerLocation(n++, location.getX(), location.getY(), location.getZ());
                for (Object object : point.getConnections().stream().filter(point2 -> point.getLocation().getWorld().equals(point2.getLocation().getWorld())).collect(Collectors.toList())) {
                    polyLineMarker.setCornerLocation(n++, ((Point)object).getLocation().getX(), ((Point)object).getLocation().getY(), ((Point)object).getLocation().getZ());
                    polyLineMarker.setCornerLocation(n++, location.getX(), location.getY(), location.getZ());
                }
            }
        }
    }

    private String translateDescriptionPlaceholders(Point point) {
        String string = this.pointMarkupDescription;
        string = string.replace("%point%", point.getSection());
        string = string.replace("%name%", point.hasName() ? point.getName() : "None");
        string = string.replace("%connectionList%", this.createConnectionList(point));
        return string;
    }

    private String createConnectionList(Point point) {
        String string = DynmapFile.getInstance().getConfig().getString("connectionListLine", "<i>%connection%</i>");
        StringBuilder stringBuilder = new StringBuilder("<ul>");
        for (Point point2 : point.getConnections()) {
            String string2 = string;
            string2 = string2.replace("%connection%", point2.getSection());
            stringBuilder.append("<li>").append(string2).append("</li>");
        }
        stringBuilder.append("</ul>");
        return stringBuilder.toString();
    }

    private void loadConfigVariables() {
        FileConfiguration fileConfiguration = DynmapFile.getInstance().getConfig();
        this.name = fileConfiguration.getString("name", "GPS");
        this.pointRadius = fileConfiguration.getDouble("pointRadius", Vars.getInstance().getPointUpdateDistance()) <= 0.0 ? Vars.getInstance().getPointUpdateDistance() : fileConfiguration.getDouble("pointRadius", Vars.getInstance().getPointUpdateDistance());
        this.pointMarkersEnabled = fileConfiguration.getBoolean("pointMarkersEnabled", true);
        this.pointFillOpacity = fileConfiguration.getDouble("pointFillOpacity", 0.4);
        String[] stringArray = fileConfiguration.getString("pointFillColor", "85,255,255").replace(" ", "").split(",");
        this.pointFillColor = 65536 * Integer.parseInt(stringArray[0]) + 256 * Integer.parseInt(stringArray[1]) + Integer.parseInt(stringArray[2]);
        this.pointBorderWeight = fileConfiguration.getInt("pointBorderWeight", 2);
        this.pointBorderOpacity = fileConfiguration.getDouble("pointBorderOpacity", 0.8);
        String[] stringArray2 = fileConfiguration.getString("pointBorderColor", "170,0,0").replace(" ", "").split(",");
        this.pointBorderColor = 65536 * Integer.parseInt(stringArray2[0]) + 256 * Integer.parseInt(stringArray2[1]) + Integer.parseInt(stringArray2[2]);
        this.pointMarkupDescription = String.join((CharSequence)"", fileConfiguration.getStringList("pointDescription"));
        this.connectionMarkersEnabled = fileConfiguration.getBoolean("connectionMarkersEnabled", true);
        this.connectionLineWeight = fileConfiguration.getInt("connectionLineWeight", 2);
        this.connectionLineOpacity = fileConfiguration.getDouble("connectionLineOpacity", 0.6);
        String[] stringArray3 = fileConfiguration.getString("connectionLineColor", "255,0,0").replace(" ", "").split(",");
        this.connectionLineColor = 65536 * Integer.parseInt(stringArray3[0]) + 256 * Integer.parseInt(stringArray3[1]) + Integer.parseInt(stringArray3[2]);
    }
}

