/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.configurator;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.configurator.Stick;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.files.PointsFile;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.playerdata.ConfiguratorData;
import com.live.bemmamin.gps.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ConfiguratorStickManager {
    private static String hiddenIdentifier;

    public void selectOrCreatePoint(Player player) {
        ConfiguratorData configuratorData = ConfiguratorData.getConfiguratorData(player);
        if (configuratorData.getStickTargetPoint() != null) {
            configuratorData.setSelectedPoint(configuratorData.getStickTargetPoint());
            MessagesFile.getInstance().getSelectedPoint().replace("%selected%", configuratorData.getSelectedPoint().getSection()).send(player);
        } else if (configuratorData.getStickTargetLocation() != null) {
            PointsFile.getInstance().getConfig().set("Points." + StringUtil.locationToString(configuratorData.getStickTargetLocation()) + ".connections", new ArrayList());
            PointsFile.getInstance().save();
            GPSManager.getInstance().loadConfigurationPoints();
            for (Point point : GPSManager.getInstance().getLocalPoints()) {
                if (!point.getSection().equals(StringUtil.locationToString(configuratorData.getStickTargetLocation()))) continue;
                if (configuratorData.isAutoConnect() && configuratorData.getSelectedPoint() != null && configuratorData.getSelectedPoint().getLocation().getWorld().getName().equals(point.getLocation().getWorld().getName())) {
                    for (int i = 0; i < 2; ++i) {
                        List list = PointsFile.getInstance().getConfig().getStringList("Points." + (i == 0 ? configuratorData.getSelectedPoint() : point).getSection() + ".connections");
                        if (list.contains((i == 0 ? point : configuratorData.getSelectedPoint()).getSection())) continue;
                        list.add((i == 0 ? point : configuratorData.getSelectedPoint()).getSection());
                        PointsFile.getInstance().getConfig().set("Points." + (i == 0 ? configuratorData.getSelectedPoint() : point).getSection() + ".connections", (Object)list);
                        PointsFile.getInstance().save();
                    }
                    GPSManager.getInstance().loadConfigurationPoints();
                    configuratorData.setSelectedPoint(GPSManager.getInstance().getLocalPoints().stream().filter(point2 -> point.getSection().equals(point2.getSection())).findFirst().orElse(null));
                    break;
                }
                configuratorData.setSelectedPoint(point);
                break;
            }
            if (Main.getDynmap() != null) {
                Main.getDynmap().updateDynmapGPS();
            }
            MessagesFile.getInstance().getPointCreated().send(player);
        } else {
            MessagesFile.getInstance().getNoPointInEyeSight().send(player);
        }
    }

    public ItemStack getStick() {
        return new Stick();
    }

    public void connectPoint(Player player) {
        ConfiguratorData configuratorData = ConfiguratorData.getConfiguratorData(player);
        List list = player.getLineOfSight(null, 100);
        for (Block block : list) {
            Location location = new Location(block.getLocation().getWorld(), (double)block.getLocation().getBlockX(), (double)block.getLocation().getBlockY(), (double)block.getLocation().getBlockZ());
            for (Point point : GPSManager.getInstance().getGlobalPoints()) {
                Location location2 = new Location(point.getLocation().getWorld(), (double)point.getLocation().getBlockX(), (double)point.getLocation().getBlockY(), (double)point.getLocation().getBlockZ());
                if (!location2.equals((Object)location)) continue;
                Point point2 = configuratorData.getClosestPoint();
                configuratorData.setClosestPoint(point);
                player.performCommand("gpsc connect");
                configuratorData.setClosestPoint(point2);
                return;
            }
        }
        MessagesFile.getInstance().getNoPointInEyeSight().send(player);
    }

    public void disconnectPoint(Player player) {
        ConfiguratorData configuratorData = ConfiguratorData.getConfiguratorData(player);
        List list = player.getLineOfSight(null, 100);
        for (Block block : list) {
            for (Point point : GPSManager.getInstance().getGlobalPoints()) {
                Location location;
                Location location2 = new Location(point.getLocation().getWorld(), (double)point.getLocation().getBlockX(), (double)point.getLocation().getBlockY(), (double)point.getLocation().getBlockZ());
                if (!location2.equals((Object)(location = new Location(block.getLocation().getWorld(), (double)block.getLocation().getBlockX(), (double)block.getLocation().getBlockY(), (double)block.getLocation().getBlockZ())))) continue;
                Point point2 = configuratorData.getClosestPoint();
                configuratorData.setClosestPoint(point);
                player.performCommand("gpsc disconnect");
                configuratorData.setClosestPoint(point2);
                return;
            }
        }
        MessagesFile.getInstance().getNoPointInEyeSight().send(player);
    }

    public void deleteTargetPoint(Player player) {
        ConfiguratorData configuratorData = ConfiguratorData.getConfiguratorData(player);
        if (configuratorData.getStickTargetPoint() != null) {
            PointsFile pointsFile = PointsFile.getInstance();
            for (Point point : GPSManager.getInstance().getGlobalPoints()) {
                List list = pointsFile.getConfig().getStringList("Points." + point.getSection() + ".connections");
                list.remove(configuratorData.getStickTargetPoint().getSection());
                pointsFile.getConfig().set("Points." + point.getSection() + ".connections", (Object)list);
            }
            pointsFile.getConfig().set("Points." + configuratorData.getStickTargetPoint().getSection(), null);
            pointsFile.save();
            GPSManager.getInstance().loadConfigurationPoints();
            configuratorData.setSelectedPoint(null);
            if (Main.getDynmap() != null) {
                Main.getDynmap().updateDynmapGPS();
            }
            MessagesFile.getInstance().getPointDeleted().send(player);
        } else {
            MessagesFile.getInstance().getNoPointInEyeSight().send(player);
        }
    }

    public static String getHiddenIdentifier() {
        return hiddenIdentifier;
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "\u00b2\u00fe\u00db\u2593\u00a2";
        for (char c : "\u00b2\u00fe\u00db\u2593\u00a2".toCharArray()) {
            stringBuilder.append("\u00a7").append(c);
        }
        hiddenIdentifier = stringBuilder.toString();
    }
}

