/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands.gps;

import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.api.events.GPSStartEvent;
import com.live.bemmamin.gps.commands.AbstractSubCommand;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.playerdata.PlayerData;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;

public class Start
extends AbstractSubCommand {
    Start() {
        super("start", PluginPermission.START, false);
        super.addAliases("s", "st");
    }

    @Override
    public void onCommand(Player player, String[] stringArray) {
        if (stringArray.length > 4 || stringArray.length < 2) {
            MessagesFile.getInstance().getInvalidArgs().send(player);
            return;
        }
        if (Vars.getInstance().isDisableGPSUsage()) {
            MessagesFile.getInstance().getGpsUsageDisabled().send(player);
            return;
        }
        if (!GPSManager.getInstance().containsPoint(stringArray[1], true)) {
            MessagesFile.getInstance().getUnknownPoint().send(player);
            return;
        }
        if (player == null) {
            this.executeAsConsole(stringArray);
        } else {
            this.executeAsPlayer(player, stringArray);
        }
    }

    private void executeAsPlayer(Player player, String[] stringArray) {
        PlayerData playerData = PlayerData.getPlayerData(player);
        Point point = GPSManager.getInstance().getPointByName(stringArray[1]);
        if (stringArray.length == 2) {
            if (this.cantStart(player, playerData, point)) {
                return;
            }
            GPSStartEvent gPSStartEvent = new GPSStartEvent(player, point);
            Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
            if (!gPSStartEvent.isCancelled()) {
                playerData.startNavigation(point, false, null);
            }
        } else {
            Point point2 = GPSManager.getInstance().getPointByName(stringArray[2]);
            if (stringArray.length == 3) {
                if (GPSManager.getInstance().containsPoint(stringArray[2], true)) {
                    if (stringArray[1].equalsIgnoreCase(stringArray[2])) {
                        MessagesFile.getInstance().getInvalidArgs().send(player);
                        return;
                    }
                    if (this.cantStart(player, playerData, point)) {
                        return;
                    }
                    GPSStartEvent gPSStartEvent = new GPSStartEvent(player, point, GPSStartEvent.StartSource.PLAYER_SELF);
                    Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
                    if (!gPSStartEvent.isCancelled()) {
                        playerData.startNavigation(point2, point, null);
                    }
                } else if (Bukkit.getPlayer((String)stringArray[2]) != null) {
                    if (!this.checkPermission(player, PluginPermission.OTHERS) || this.cantStart(player, playerData, point)) {
                        return;
                    }
                    GPSStartEvent gPSStartEvent = new GPSStartEvent(Bukkit.getPlayer((String)stringArray[2]), point, GPSStartEvent.StartSource.PLAYER_OTHER);
                    Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
                    if (!gPSStartEvent.isCancelled()) {
                        MessagesFile.getInstance().getStartedGPSPlayer().replace("%player%", Bukkit.getPlayer((String)stringArray[2]).getName()).send(player);
                        PlayerData.getPlayerData(Bukkit.getPlayer((String)stringArray[2])).startNavigation(point, false, null);
                    }
                } else {
                    MessagesFile.getInstance().getUnknownPlayer().send(player);
                }
            } else {
                if (!this.checkPermission(player, PluginPermission.OTHERS)) {
                    return;
                }
                Player player2 = Bukkit.getPlayer((String)stringArray[3]);
                if (!GPSManager.getInstance().containsPoint(stringArray[2], true)) {
                    MessagesFile.getInstance().getUnknownPoint().send(player);
                    return;
                }
                if (player2 == null) {
                    MessagesFile.getInstance().getUnknownPlayer().send(player);
                    return;
                }
                if (stringArray[1].equalsIgnoreCase(stringArray[2])) {
                    MessagesFile.getInstance().getInvalidArgs().send(player);
                    return;
                }
                if (this.cantStart(player2, playerData, point)) {
                    return;
                }
                GPSStartEvent gPSStartEvent = new GPSStartEvent(player2, point, GPSStartEvent.StartSource.PLAYER_OTHER);
                Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
                if (!gPSStartEvent.isCancelled()) {
                    PlayerData.getPlayerData(player2).startNavigation(point2, point, null);
                }
            }
        }
    }

    private boolean cantStart(Player player, PlayerData playerData, Point point) {
        if (playerData.isToggledOff()) {
            MessagesFile.getInstance().getToggledOff().send(player);
            return true;
        }
        if (point.hasPermission() && !PluginPermission.hasArbitraryPermission((Permissible)player, point.getPermission())) {
            MessagesFile.getInstance().getInvalidPermission().send(player);
            return true;
        }
        return false;
    }

    private void executeAsConsole(String[] stringArray) {
        if (stringArray.length != 3 && stringArray.length != 4) {
            MessagesFile.getInstance().getPlayerOnly().send(null);
            return;
        }
        if (stringArray.length == 3) {
            Player player = Bukkit.getPlayer((String)stringArray[2]);
            if (player == null) {
                MessagesFile.getInstance().getUnknownPlayer().send(null);
                return;
            }
            PlayerData playerData = PlayerData.getPlayerData(player);
            if (playerData.isToggledOff()) {
                return;
            }
            GPSStartEvent gPSStartEvent = new GPSStartEvent(player, GPSManager.getInstance().getPointByName(stringArray[1]), GPSStartEvent.StartSource.CONSOLE);
            Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
            if (!gPSStartEvent.isCancelled()) {
                MessagesFile.getInstance().getStartedGPSPlayer().replace("%player%", player.getName()).send(null);
                playerData.startNavigation(GPSManager.getInstance().getPointByName(stringArray[1]), false, null);
            }
        } else {
            Player player = Bukkit.getPlayer((String)stringArray[3]);
            if (!GPSManager.getInstance().containsPoint(stringArray[2], true)) {
                MessagesFile.getInstance().getUnknownPoint().send(null);
                return;
            }
            if (player == null) {
                MessagesFile.getInstance().getUnknownPlayer().send(null);
                return;
            }
            if (stringArray[1].equalsIgnoreCase(stringArray[2])) {
                MessagesFile.getInstance().getInvalidArgs().send(null);
                return;
            }
            PlayerData playerData = PlayerData.getPlayerData(player);
            if (playerData.isToggledOff()) {
                return;
            }
            GPSStartEvent gPSStartEvent = new GPSStartEvent(player, GPSManager.getInstance().getPointByName(stringArray[2]), GPSStartEvent.StartSource.CONSOLE);
            Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
            if (!gPSStartEvent.isCancelled()) {
                MessagesFile.getInstance().getStartedGPSPlayer().replace("%player%", player.getName()).send(null);
                playerData.startNavigation(GPSManager.getInstance().getPointByName(stringArray[1]), GPSManager.getInstance().getPointByName(stringArray[2]), null);
            }
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] stringArray) {
        if (stringArray.length == 1) {
            return GPSManager.getInstance().getGlobalPoints().stream().filter(point -> point.hasName() && point.getName().toLowerCase().startsWith(stringArray[0].toLowerCase())).map(Point::getName).collect(Collectors.toList());
        }
        if (stringArray.length == 2 && PluginPermission.OTHERS.hasPermission((Permissible)player)) {
            return null;
        }
        return Collections.emptyList();
    }
}

