/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands.gps;

import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.commands.AbstractSubCommand;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.utils.JsonUtil;
import com.live.bemmamin.gps.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class List
extends AbstractSubCommand {
    private static final int ENTRIES_PER_PAGE = 8;

    List() {
        super("list", PluginPermission.LIST, false);
        super.addAliases("l");
    }

    @Override
    public void onCommand(Player player, String[] stringArray) {
        if (stringArray.length > 2 || stringArray.length < 1) {
            MessagesFile.getInstance().getInvalidArgs().send(player);
            return;
        }
        long l = GPSManager.getInstance().getGlobalPoints().stream().filter(Point::hasName).count();
        int n = (int)Math.ceil((double)l / 8.0);
        if (n == 0) {
            n = 1;
        }
        int n2 = 1;
        if (stringArray.length == 2) {
            try {
                n2 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                MessagesFile.getInstance().getInvalidArgs().send(player);
                return;
            }
        }
        if (n2 > n || n2 < 1) {
            MessagesFile.getInstance().getInvalidArgs().send(player);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Point point2 : GPSManager.getInstance().getGlobalPoints()) {
            if (!point2.hasName()) continue;
            arrayList.add(point2.getName());
        }
        StringUtil.msgSend(player, "&9&m&l---&9 Page: &c" + n2 + "/" + n + " &9&m&l-----------------");
        for (int i = (n2 - 1) * 8; i < n2 * 8; ++i) {
            Point point;
            Point point2;
            if (i >= arrayList.size()) continue;
            point2 = GPSManager.getInstance().getPointByName((String)arrayList.get(i));
            StringBuilder stringBuilder = new StringBuilder();
            Object object = point2.getConnections().iterator();
            while (object.hasNext()) {
                point = object.next();
                stringBuilder.append("\n&7&l \u25cf &e").append(point.getName());
            }
            Object object2 = player != null ? (PluginPermission.GPS_CONFIGURATOR.hasPermission((Permissible)player) ? "\n\n&7Click to teleport." : "") : (object = "");
            point = player != null ? (PluginPermission.GPS_CONFIGURATOR.hasPermission((Permissible)player) ? "/gpsc teleport " + point2.getName() : null) : null;
            JsonUtil.msgSend(player, "&7&l \u25cf&e " + point2.getName(), "&9Location: &e" + StringUtil.locationToString(point2.getLocation()) + "\n&9Connections:" + stringBuilder.toString() + (String)object, (String)((Object)point), ClickEvent.Action.RUN_COMMAND);
        }
        if (n2 != n) {
            JsonUtil.msgSend(player, "&eUse &c/gps list " + (n2 + 1) + "&e to go to the next page.", "&7Click to go to the next page.", "/gps list " + (n2 + 1), ClickEvent.Action.RUN_COMMAND);
        }
    }

    @Override
    public java.util.List<String> onTabComplete(Player player, String[] stringArray) {
        if (stringArray.length == 1) {
            long l = GPSManager.getInstance().getGlobalPoints().stream().filter(Point::hasName).count();
            int n = (int)Math.ceil((double)l / 8.0);
            return IntStream.range(1, n == 0 ? 2 : n + 1).mapToObj(String::valueOf).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

