/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands.configurator;

import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.commands.AbstractSubCommand;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Teleport
extends AbstractSubCommand {
    Teleport() {
        super("teleport", PluginPermission.GPS_CONFIGURATOR, true);
        super.addAliases("tele", "tp");
        super.setInvalidPermissionMessage(MessagesFile.getInstance().getNoCommands().toString());
    }

    @Override
    public void onCommand(Player player, String[] stringArray) {
        if (stringArray.length != 2) {
            MessagesFile.getInstance().getInvalidArgsConf().send(player);
            return;
        }
        Point point2 = GPSManager.getInstance().getGlobalPoints().stream().filter(point -> point.hasName() && point.getName().equalsIgnoreCase(stringArray[1])).findFirst().orElse(null);
        if (point2 != null) {
            player.teleport(point2.getLocation());
            MessagesFile.getInstance().getTeleportedToPoint().send(player);
        } else {
            MessagesFile.getInstance().getUnknownPoint().send(player);
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] stringArray) {
        return GPSManager.getInstance().getGlobalPoints().stream().filter(point -> point.hasName() && point.getName().toLowerCase().startsWith(stringArray[0].toLowerCase())).map(Point::getName).collect(Collectors.toList());
    }
}

