/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands.configurator;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.commands.AbstractSubCommand;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.files.PointsFile;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.playerdata.ConfiguratorData;
import com.live.bemmamin.gps.utils.StringUtil;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class Move
extends AbstractSubCommand {
    Move() {
        super("move", PluginPermission.GPS_CONFIGURATOR, true);
        super.addAliases("m");
        super.setInvalidPermissionMessage(MessagesFile.getInstance().getNoCommands().toString());
    }

    @Override
    public void onCommand(Player player, String[] stringArray) {
        ConfiguratorData configuratorData = ConfiguratorData.getConfiguratorData(player);
        PointsFile pointsFile = PointsFile.getInstance();
        if (!configuratorData.isEditorActivated()) {
            MessagesFile.getInstance().getEditorInactive().send(player);
            return;
        }
        if (configuratorData.getSelectedPoint() == null) {
            MessagesFile.getInstance().getNoPointSelected().send(player);
            return;
        }
        for (Point point : GPSManager.getInstance().getGlobalPoints()) {
            if (!point.getLocation().equals((Object)new Location(player.getWorld(), (double)player.getLocation().getBlockX() + 0.5, (double)player.getLocation().getBlockY() + 0.1, (double)player.getLocation().getBlockZ() + 0.5))) continue;
            MessagesFile.getInstance().getLocationsHasPoint().send(player);
            return;
        }
        ConfigurationSection configurationSection = pointsFile.getConfig().getConfigurationSection("Points." + configuratorData.getSelectedPoint().getSection());
        pointsFile.getConfig().set("Points." + StringUtil.locationToString(player.getLocation()), (Object)configurationSection);
        pointsFile.getConfig().set("Points." + configuratorData.getSelectedPoint().getSection(), null);
        pointsFile.save();
        configuratorData.setSelectedPoint(null);
        PointsFile.reload();
        GPSManager.getInstance().loadConfigurationPoints();
        if (Main.getDynmap() != null) {
            Main.getDynmap().updateDynmapGPS();
        }
        MessagesFile.getInstance().getMovedPoint().send(player);
    }
}

