/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands.configurator;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.commands.AbstractSubCommand;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.playerdata.ConfiguratorData;
import com.live.bemmamin.gps.utils.ParticleUtil;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Editor
extends AbstractSubCommand {
    private final Main main;

    Editor(Main main) {
        super("editor", PluginPermission.GPS_CONFIGURATOR, true);
        super.addAliases("edit", "e");
        super.setInvalidPermissionMessage(MessagesFile.getInstance().getNoCommands().toString());
        this.main = main;
    }

    @Override
    public void onCommand(final Player player, String[] stringArray) {
        ConfiguratorData configuratorData = ConfiguratorData.getConfiguratorData(player);
        boolean bl = !configuratorData.isEditorActivated();
        configuratorData.setEditorActivated(bl);
        if (bl) {
            long l = Vars.getInstance().getParticleUpdateRate();
            BukkitTask bukkitTask = new BukkitRunnable(){
                final Player p;
                {
                    this.p = player;
                }

                public void run() {
                    new ParticleUtil(this.p).highlightPointsAndConnections();
                }
            }.runTaskTimer((Plugin)this.main, 0L, l);
            configuratorData.setVisualPointsTask(bukkitTask);
        } else {
            configuratorData.cancelVisualPointsTask();
        }
        MessagesFile.getInstance().getToggleEditor().replace("%state%", bl ? "activated" : "deactivated").send(player);
    }
}

