/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands.configurator;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.commands.AbstractSubCommand;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.files.PointsFile;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.playerdata.ConfiguratorData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class Attribute
extends AbstractSubCommand {
    Attribute() {
        super("attribute", PluginPermission.GPS_CONFIGURATOR, true);
        super.addAliases("att", "ab", "a");
        super.setInvalidPermissionMessage(MessagesFile.getInstance().getNoCommands().toString());
    }

    @Override
    public void onCommand(Player player, String[] stringArray) {
        ConfiguratorData configuratorData = ConfiguratorData.getConfiguratorData(player);
        PointsFile pointsFile = PointsFile.getInstance();
        if (!configuratorData.isEditorActivated()) {
            MessagesFile.getInstance().getEditorInactive().send(player);
            return;
        }
        if (configuratorData.getSelectedPoint() == null) {
            MessagesFile.getInstance().getNoPointSelected().send(player);
            return;
        }
        if (stringArray.length < 2) {
            MessagesFile.getInstance().getInvalidArgsConf().send(player);
            return;
        }
        boolean bl = stringArray.length == 2;
        for (Attributes attributes : Attributes.values()) {
            if (!attributes.isSpecifiedAttribute(stringArray[1])) continue;
            if (bl) {
                pointsFile.getConfig().set("Points." + configuratorData.getSelectedPoint().getSection() + "." + attributes.getPath(), null);
                pointsFile.save();
                GPSManager.getInstance().loadConfigurationPoints();
                if (Main.getDynmap() != null) {
                    Main.getDynmap().updateDynmapGPS();
                }
                MessagesFile.getInstance().getAttributeRemoved().send(player);
                return;
            }
            List list = stringArray[2];
            switch (attributes) {
                case NAME: 
                case PERMISSION: {
                    if (stringArray.length == 3) break;
                    MessagesFile.getInstance().getInvalidAttributeValue().send(player);
                    return;
                }
                case UPDATE_DISTANCE: {
                    if (stringArray.length != 3) {
                        MessagesFile.getInstance().getInvalidAttributeValue().send(player);
                        return;
                    }
                    try {
                        list = Double.parseDouble((String)((Object)list));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        MessagesFile.getInstance().getInvalidAttributeValue().send(player);
                        return;
                    }
                }
                case CUSTOM_MESSAGE: {
                    list = String.join((CharSequence)" ", Arrays.copyOfRange(stringArray, 2, stringArray.length));
                    break;
                }
                case FLAG: {
                    if (stringArray.length != 4 || !Arrays.asList("a", "add", "r", "rem", "remove").contains(((String)((Object)list)).toLowerCase())) {
                        MessagesFile.getInstance().getInvalidAttributeValue().send(player);
                        return;
                    }
                    if (Arrays.asList("a", "add").contains(((String)((Object)list)).toLowerCase())) {
                        list = Stream.concat(new ArrayList<String>(configuratorData.getSelectedPoint().getFlags()).stream(), Stream.of(stringArray[3])).distinct().collect(Collectors.toList());
                        break;
                    }
                    list = new ArrayList<String>(configuratorData.getSelectedPoint().getFlags()).stream().filter(string -> !string.equalsIgnoreCase(stringArray[3])).collect(Collectors.toList());
                    break;
                }
                case SOUND: {
                    if (stringArray.length != 3) {
                        MessagesFile.getInstance().getInvalidAttributeValue().send(player);
                        return;
                    }
                    try {
                        Sound.valueOf((String)((Object)list));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        MessagesFile.getInstance().getInvalidAttributeValue().send(player);
                        return;
                    }
                }
            }
            MessagesFile.getInstance().getAttributeAdded().send(player);
            pointsFile.getConfig().set("Points." + configuratorData.getSelectedPoint().getSection() + "." + attributes.getPath(), (Object)list);
            pointsFile.save();
            if (Main.getDynmap() != null) {
                Main.getDynmap().updateDynmapGPS();
            }
            GPSManager.getInstance().loadConfigurationPoints();
            return;
        }
        MessagesFile.getInstance().getUnknownAttribute().send(player);
    }

    @Override
    public List<String> onTabComplete(Player player, String[] stringArray) {
        Point point;
        if (stringArray.length == 1) {
            return Stream.of(Attributes.values()).map(Attributes::getPath).filter(string -> string.startsWith(stringArray[0].toLowerCase())).collect(Collectors.toList());
        }
        if (stringArray.length == 2) {
            if (Attributes.UPDATE_DISTANCE.isSpecifiedAttribute(stringArray[0])) {
                return Collections.singletonList(String.valueOf(Vars.getInstance().getPointUpdateDistance()));
            }
            if (Attributes.FLAG.isSpecifiedAttribute(stringArray[0])) {
                return Arrays.asList("add", "remove");
            }
            if (Attributes.SOUND.isSpecifiedAttribute(stringArray[0])) {
                return Arrays.stream(Sound.values()).map(Enum::toString).filter(string -> string.toLowerCase().startsWith(stringArray[1].toLowerCase())).collect(Collectors.toList());
            }
        } else if (stringArray.length == 3 && Attributes.FLAG.isSpecifiedAttribute(stringArray[0]) && Stream.of("a", "add", "r", "rem", "remove").anyMatch(string -> string.equalsIgnoreCase(stringArray[1])) && (point = ConfiguratorData.getConfiguratorData(player).getSelectedPoint()) != null) {
            return point.getFlags();
        }
        return Collections.emptyList();
    }

    private static enum Attributes {
        NAME("name", "name", "n"),
        UPDATE_DISTANCE("updateDistance", "updatedistance", "updatedist", "udistance", "udist", "updist", "ud"),
        CUSTOM_MESSAGE("message", "message", "msg", "m"),
        FLAG("flags", "flags", "flag", "fl", "f"),
        PERMISSION("permission", "permission", "perm", "p"),
        SOUND("sound", "sound", "s");

        private final String path;
        private final List<String> identifiers;

        private Attributes(String string2, String ... stringArray) {
            this.path = string2;
            this.identifiers = Arrays.asList(stringArray);
        }

        boolean isSpecifiedAttribute(String string) {
            return this.identifiers.contains(string.toLowerCase());
        }

        public String getPath() {
            return this.path;
        }
    }
}

