/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands.compass;

import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.api.events.GPSStopEvent;
import com.live.bemmamin.gps.commands.AbstractSubCommand;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.StringUtil;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Stop
extends AbstractSubCommand {
    Stop() {
        super("stop", null, false);
    }

    @Override
    public void onCommand(Player player, String[] stringArray) {
        if (stringArray.length > 2) {
            MessagesFile.getInstance().getInvalidArgs().send(player);
            return;
        }
        if (player == null && stringArray.length == 1) {
            MessagesFile.getInstance().getPlayerOnly().send();
            return;
        }
        if (stringArray.length == 1) {
            PlayerData playerData = PlayerData.getPlayerData(player);
            if (!playerData.isGpsActive()) {
                MessagesFile.getInstance().getNotStarted().send(player);
                return;
            }
            GPSStopEvent gPSStopEvent = new GPSStopEvent(player, GPSStopEvent.StopSource.PLAYER_SELF);
            Bukkit.getPluginManager().callEvent((Event)gPSStopEvent);
            if (!gPSStopEvent.isCancelled()) {
                StringUtil.msgSend(player, gPSStopEvent.getCustomStopMessage() == null ? (playerData.isCompassMode() ? MessagesFile.getInstance().getStoppedCompass() : MessagesFile.getInstance().getStoppedGPS()).toString() : gPSStopEvent.getCustomStopMessage());
                playerData.exitNavigation();
            }
            return;
        }
        if (player != null && !this.checkPermission(player, PluginPermission.OTHERS)) {
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[1]);
        if (offlinePlayer != null && PlayerData.contains(offlinePlayer.getUniqueId())) {
            PlayerData playerData = PlayerData.getPlayerData(offlinePlayer.getUniqueId());
            if (!playerData.isGpsActive()) {
                MessagesFile.getInstance().getNotStarted().send(player);
                return;
            }
            GPSStopEvent gPSStopEvent = new GPSStopEvent(offlinePlayer.getPlayer(), player == null ? GPSStopEvent.StopSource.CONSOLE : GPSStopEvent.StopSource.PLAYER_OTHER);
            Bukkit.getPluginManager().callEvent((Event)gPSStopEvent);
            if (!gPSStopEvent.isCancelled()) {
                MessagesFile.getInstance().getStoppedCompassPlayer().replace("%player%", offlinePlayer.getName()).send(player);
                if (offlinePlayer.isOnline()) {
                    StringUtil.msgSend(offlinePlayer.getPlayer(), gPSStopEvent.getCustomStopMessage() == null ? (playerData.isCompassMode() ? MessagesFile.getInstance().getStoppedCompass() : MessagesFile.getInstance().getStoppedGPS()).toString() : gPSStopEvent.getCustomStopMessage());
                }
                playerData.exitNavigation();
            }
            return;
        }
        MessagesFile.getInstance().getUnknownPlayer().send(player);
    }
}

