/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands.compass;

import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.api.events.GPSStartEvent;
import com.live.bemmamin.gps.commands.AbstractSubCommand;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.playerdata.PlayerData;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;

public class Start
extends AbstractSubCommand {
    Start() {
        super("start", PluginPermission.START, false);
        super.addAliases("s");
    }

    @Override
    public void onCommand(Player player, String[] stringArray) {
        if (stringArray.length > 5 || stringArray.length < 2) {
            MessagesFile.getInstance().getInvalidArgs().send(player);
            return;
        }
        if (Vars.getInstance().isDisableGPSUsage()) {
            MessagesFile.getInstance().getCompassUsageDisabled().send(player);
            return;
        }
        if (stringArray.length == 4 || stringArray.length == 5) {
            if (stringArray.length == 4 && player == null) {
                MessagesFile.getInstance().getPlayerOnly().send();
                return;
            }
            this.startWithCoordinates(player, stringArray);
            return;
        }
        if (!GPSManager.getInstance().containsPoint(stringArray[1], true)) {
            MessagesFile.getInstance().getUnknownPoint().send(player);
            return;
        }
        if (player == null) {
            this.executeAsConsole(stringArray);
        } else {
            this.executeAsPlayer(player, stringArray);
        }
    }

    private void executeAsPlayer(Player player, String[] stringArray) {
        Point point = GPSManager.getInstance().getPointByName(stringArray[1]);
        if (stringArray.length == 2) {
            PlayerData playerData = PlayerData.getPlayerData(player);
            if (this.cantStart(player, playerData, point)) {
                return;
            }
            GPSStartEvent gPSStartEvent = new GPSStartEvent(player, point, GPSStartEvent.StartSource.PLAYER_SELF, true);
            Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
            if (!gPSStartEvent.isCancelled()) {
                playerData.startNavigation(point, true, null);
            }
        } else {
            Player player2 = Bukkit.getPlayer((String)stringArray[2]);
            if (player2 == null) {
                MessagesFile.getInstance().getUnknownPlayer().send(player);
                return;
            }
            if (!this.checkPermission(player, PluginPermission.OTHERS)) {
                return;
            }
            PlayerData playerData = PlayerData.getPlayerData(player2);
            if (this.cantStart(player2, playerData, point)) {
                return;
            }
            GPSStartEvent gPSStartEvent = new GPSStartEvent(player2, point, GPSStartEvent.StartSource.PLAYER_OTHER, true);
            Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
            if (!gPSStartEvent.isCancelled()) {
                MessagesFile.getInstance().getStartedCompassPlayer().replace("%player%", player2.getName()).send(player);
                playerData.startNavigation(point, true, null);
            }
        }
    }

    private boolean cantStart(Player player, PlayerData playerData, Point point) {
        if (playerData.isToggledOff()) {
            MessagesFile.getInstance().getToggledOff().send(player);
            return true;
        }
        if (point.hasPermission() && !PluginPermission.hasArbitraryPermission((Permissible)player, point.getPermission())) {
            MessagesFile.getInstance().getInvalidPermission().send(player);
            return true;
        }
        return false;
    }

    private void executeAsConsole(String[] stringArray) {
        if (stringArray.length != 3) {
            MessagesFile.getInstance().getPlayerOnly().send();
            return;
        }
        Player player = Bukkit.getPlayer((String)stringArray[2]);
        if (player == null) {
            MessagesFile.getInstance().getUnknownPlayer().send();
            return;
        }
        PlayerData playerData = PlayerData.getPlayerData(player);
        if (playerData.isToggledOff()) {
            return;
        }
        GPSStartEvent gPSStartEvent = new GPSStartEvent(player, GPSManager.getInstance().getPointByName(stringArray[1]), GPSStartEvent.StartSource.CONSOLE, true);
        Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
        if (!gPSStartEvent.isCancelled()) {
            MessagesFile.getInstance().getStartedCompassPlayer().replace("%player%", player.getName()).send();
            playerData.startNavigation(GPSManager.getInstance().getPointByName(stringArray[1]), true, null);
        }
    }

    private void startWithCoordinates(Player player, String[] stringArray) {
        double d;
        double d2;
        double d3;
        Player player2;
        Player player3 = player2 = stringArray.length == 4 ? player : Bukkit.getPlayer((String)stringArray[4]);
        if (player != null && stringArray.length == 5 && !this.checkPermission(player, PluginPermission.OTHERS)) {
            return;
        }
        if (player2 == null) {
            MessagesFile.getInstance().getUnknownPlayer().send(player);
            return;
        }
        try {
            d3 = Double.parseDouble(stringArray[1]);
            d2 = Double.parseDouble(stringArray[2]);
            d = Double.parseDouble(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            MessagesFile.getInstance().getInvalidArgs().send(player);
            return;
        }
        Point point = new Point("", new Location(player2.getWorld(), d3, d2, d));
        PlayerData playerData = PlayerData.getPlayerData(player2);
        if (playerData.isToggledOff()) {
            if (stringArray.length == 4) {
                MessagesFile.getInstance().getToggledOff().send(player);
            }
            return;
        }
        GPSStartEvent gPSStartEvent = new GPSStartEvent(player2, point, stringArray.length == 4 ? GPSStartEvent.StartSource.PLAYER_SELF : (player == null ? GPSStartEvent.StartSource.CONSOLE : GPSStartEvent.StartSource.PLAYER_OTHER), true);
        Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
        if (!gPSStartEvent.isCancelled()) {
            if (stringArray.length != 4) {
                MessagesFile.getInstance().getStartedCompassPlayer().replace("%player%", player2.getName()).send(player);
            }
            playerData.startNavigation(point, true, null);
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] stringArray) {
        if (stringArray.length == 1) {
            return GPSManager.getInstance().getGlobalPoints().stream().filter(point -> point.hasName() && point.getName().startsWith(stringArray[0].toLowerCase())).map(Point::getName).collect(Collectors.toList());
        }
        if (stringArray.length == 2 && PluginPermission.OTHERS.hasPermission((Permissible)player)) {
            return null;
        }
        return Collections.emptyList();
    }
}

