/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands.compass;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.commands.AbstractCommand;
import com.live.bemmamin.gps.commands.compass.Help;
import com.live.bemmamin.gps.commands.compass.Show;
import com.live.bemmamin.gps.commands.compass.Start;
import com.live.bemmamin.gps.commands.compass.Stop;
import com.live.bemmamin.gps.commands.gps.Toggle;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CompassCommand
extends AbstractCommand {
    public CompassCommand(Main main) {
        super("compass");
        super.addSubCommands(new Help(), new Start(), new Stop(), new Show(main), new Toggle());
    }

    @Override
    protected void onCommand(Player player, String string2, String[] stringArray) {
        if (player != null && stringArray.length != 0 && PluginPermission.START.hasPermission((Permissible)player)) {
            Point point = GPSManager.getInstance().getPointByName(stringArray[0]);
            boolean bl = false;
            if (stringArray.length == 3 || stringArray.length == 4) {
                bl = Stream.of(stringArray[0], stringArray[1], stringArray[2]).allMatch(string -> {
                    try {
                        Double.parseDouble(string);
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                });
            }
            if (point != null || bl) {
                LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
                linkedList.addFirst("start");
                this.getSubCommands().stream().filter(abstractSubCommand -> abstractSubCommand.getName().equalsIgnoreCase("start")).findFirst().ifPresent(abstractSubCommand -> abstractSubCommand.onCommand(player, linkedList.toArray(new String[0])));
                return;
            }
        }
        if (this.checkPermission(PluginPermission.HELP, MessagesFile.getInstance().getInvalidPermission().toString())) {
            this.getSubCommands().stream().filter(abstractSubCommand -> abstractSubCommand.getName().equalsIgnoreCase("help")).findFirst().ifPresent(abstractSubCommand -> abstractSubCommand.onCommand(player, stringArray));
        }
    }
}

