/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands.admin;

import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.commands.AbstractSubCommand;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.JsonUtil;
import com.live.bemmamin.gps.utils.StringUtil;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Active
extends AbstractSubCommand {
    private static final int ENTRIES_PER_PAGE = 8;

    Active() {
        super("active", PluginPermission.GPS_ADMIN, false);
        super.addAliases("act", "a");
    }

    @Override
    public void onCommand(Player player, String[] stringArray) {
        if (stringArray.length > 2 || stringArray.length < 1) {
            MessagesFile.getInstance().getInvalidArgs().send(player);
            return;
        }
        List list = PlayerData.getPlayerData().entrySet().stream().filter(entry -> ((PlayerData)entry.getValue()).isGpsActive()).collect(Collectors.toList());
        long l = list.size();
        if (l == 0L) {
            MessagesFile.getInstance().getNoActiveGPSes().send(player);
            return;
        }
        int n = (int)Math.ceil((double)l / 8.0);
        if (n == 0) {
            n = 1;
        }
        int n2 = 1;
        if (stringArray.length == 2) {
            try {
                n2 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                MessagesFile.getInstance().getInvalidArgs().send(player);
                return;
            }
        }
        if (n2 > n || n2 < 1) {
            MessagesFile.getInstance().getInvalidArgs().send(player);
            return;
        }
        StringUtil.msgSend(player, "&9&m&l---&9 Page: &c" + n2 + "/" + n + " &9&m&l-----------------");
        list.subList((n2 - 1) * 8, n2 * 8 >= list.size() ? list.size() : n2 * 8).forEach(entry -> {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey()));
            JsonUtil.msgSend(player, "&7&l \u25cf&e " + offlinePlayer.getName(), "&eInfo:\n  &7&l\u25cf &eMode: &a" + (((PlayerData)entry.getValue()).isCompassMode() ? "Compass\n" : "GPS\n") + "  &7&l\u25cf &eOnline: &a" + ((PlayerData)entry.getValue()).isIdle() + ".\n" + (((PlayerData)entry.getValue()).isIdle() ? "  &7&l\u25cf &eIdle for: &a" + (Instant.now().getEpochSecond() - ((PlayerData)entry.getValue()).getQuitTime()) + " seconds\n" : "") + "  &7&l\u25cf &eTotal Distance: &a" + String.format("%.2f", ((PlayerData)entry.getValue()).getArrow().getTotalDistanceToTarget()) + " blocks\n  &7&l\u25cf &eDistance Covered: &a" + String.format("%.2f", ((PlayerData)entry.getValue()).getArrow().getTotalDistanceToTarget() - ((PlayerData)entry.getValue()).getArrow().getRemainingDistanceToTarget()) + " blocks\n  &7&l\u25cf &eDistance Left: &a" + String.format("%.2f", ((PlayerData)entry.getValue()).getArrow().getRemainingDistanceToTarget()) + " blocks\n\n&7Click to stop the GPS.", "/gps stop " + offlinePlayer.getName(), ClickEvent.Action.RUN_COMMAND);
        });
        if (n2 != n) {
            JsonUtil.msgSend(player, "&eUse &c/gpsa list " + (n2 + 1) + "&e to go to the next page.", "&7Click to go to the next page.", "/gpsa active " + (n2 + 1), ClickEvent.Action.RUN_COMMAND);
        }
    }

    @Override
    public List<String> onTabComplete(Player player, String[] stringArray) {
        long l;
        if (stringArray.length == 1 && (l = PlayerData.getPlayerData().entrySet().stream().filter(entry -> ((PlayerData)entry.getValue()).isGpsActive()).count()) != 0L) {
            int n = (int)Math.ceil((double)l / 8.0);
            return IntStream.range(1, n == 0 ? 2 : n + 1).mapToObj(String::valueOf).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

